/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet;

import com.google.common.base.Optional;
import java.io.IOException;
import java.security.Principal;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.servlet.ServletPrincipalConverter;

@Component(priority=-180)
public class ServletSecurityFilter
implements RestxFilter,
RestxHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServletSecurityFilter.class);
    private final ServletPrincipalConverter servletPrincipalConverter;

    public ServletSecurityFilter(@Named(value="ServletPrincipalConverter") ServletPrincipalConverter servletPrincipalConverter) {
        this.servletPrincipalConverter = servletPrincipalConverter;
    }

    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)req.unwrap(HttpServletRequest.class);
            if (httpServletRequest.getUserPrincipal() != null) {
                return Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)new StdRestxRequestMatch("*", req.getRestxPath()), (RestxHandler)this));
            }
            return Optional.absent();
        }
        catch (IllegalArgumentException ex) {
            return Optional.absent();
        }
        catch (NoClassDefFoundError e) {
            if ("javax/servlet/http/HttpServletRequest".equals(e.getMessage())) {
                return Optional.absent();
            }
            throw e;
        }
    }

    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)req.unwrap(HttpServletRequest.class);
        Principal userPrincipal = httpServletRequest.getUserPrincipal();
        if (userPrincipal != null) {
            logger.debug("setting restx principal from http servlet request {}", (Object)userPrincipal);
            if (userPrincipal instanceof RestxPrincipal) {
                RestxSession.current().authenticateAs((RestxPrincipal)userPrincipal);
            } else {
                RestxSession.current().authenticateAs(this.servletPrincipalConverter.toRestxPrincipal(userPrincipal));
            }
        }
        ctx.nextHandlerMatch().handle(req, resp, ctx);
    }
}

