/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Optional;
import restx.RestxLogLevel;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.annotations.RestxResource;
import restx.annotations.Verbosity;
import restx.factory.Component;
import restx.factory.When;
import restx.security.RolesAllowed;
import restx.tests.RestxSpecTestServer;
import restx.tests.TestRequest;
import restx.tests.TestResult;
import restx.tests.TestResultSummary;

@Component
@RestxResource(group="restx-admin")
@When(name="restx.mode", value="infinirest")
public class SpecTestResource {
    private final RestxSpecTestServer.RunningServer server;

    public SpecTestResource(RestxSpecTestServer.RunningServer server) {
        this.server = server;
    }

    @RolesAllowed(value={"restx-admin"})
    @POST(value="/@/tests/requests")
    public TestRequest submitTestRequest(TestRequest testRequest) {
        return this.server.submitTestRequest(testRequest);
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/tests/requests/{key}")
    public Optional<TestRequest> getTestRequestByKey(String key) {
        return this.server.getRequestByKey(key);
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/tests/results/summaries")
    @Verbosity(value=RestxLogLevel.QUIET)
    public Iterable<TestResultSummary> findCurrentTestResults() {
        return this.server.findCurrentTestResults();
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/tests/results/{key}")
    public Optional<TestResult> getTestResultByKey(String key) {
        return this.server.getResultByKey(key);
    }
}

