/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.annotations.Verbosity;
import restx.common.TypeReference;
import restx.common.Types;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.factory.When;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.specs.SpecTestResource;
import restx.tests.TestRequest;
import restx.tests.TestResult;
import restx.tests.TestResultSummary;
import restx.validation.Validations;

@Component(priority=0)
@When(name="restx.mode", value="infinirest")
public class SpecTestResourceRouter
extends RestxRouter {
    public SpecTestResourceRouter(final SpecTestResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "SpecTestResourceRouter", new RestxRoute[]{new StdEntityRoute<TestRequest, TestRequest>("restx-admin#SpecTestResource#submitTestRequest", readerRegistry.build(TestRequest.class, Optional.absent()), writerRegistry.build(TestRequest.class, Optional.absent()), Endpoint.of((String)"POST", (String)"/@/tests/requests"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<TestRequest> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, TestRequest body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.submitTestRequest((TestRequest)Validations.checkValid((Optional)validator, (Object)Preconditions.checkNotNull((Object)body, (Object)"body param <testRequest> is required"), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription testRequest = new OperationParameterDescription();
                testRequest.name = "testRequest";
                testRequest.paramType = OperationParameterDescription.ParamType.body;
                testRequest.dataType = "TestRequest";
                testRequest.schemaKey = "restx.tests.TestRequest";
                testRequest.required = true;
                operation.parameters.add(testRequest);
                operation.responseClass = "TestRequest";
                operation.inEntitySchemaKey = "restx.tests.TestRequest";
                operation.inEntityType = TestRequest.class;
                operation.outEntitySchemaKey = "restx.tests.TestRequest";
                operation.outEntityType = TestRequest.class;
                operation.sourceLocation = "restx.specs.SpecTestResource#submitTestRequest(restx.tests.TestRequest)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new POST(){

                    public Class<POST> annotationType() {
                        return POST.class;
                    }

                    public String value() {
                        return "/@/tests/requests";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, TestRequest>("restx-admin#SpecTestResource#getTestRequestByKey", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(TestRequest.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/tests/requests/{key}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"key")}){

            protected Optional<TestRequest> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return resource.getTestRequestByKey((String)Validations.checkValid((Optional)validator, (Object)Preconditions.checkNotNull((Object)this.mapQueryObjectFromRequest(String.class, "key", request, match, EndpointParameterKind.PATH), (Object)"PATH param <key> is required"), (Class[])new Class[0]));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription key = new OperationParameterDescription();
                key.name = "key";
                key.paramType = OperationParameterDescription.ParamType.path;
                key.dataType = "string";
                key.schemaKey = "";
                key.required = true;
                operation.parameters.add(key);
                operation.responseClass = "TestRequest";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.tests.TestRequest";
                operation.outEntityType = TestRequest.class;
                operation.sourceLocation = "restx.specs.SpecTestResource#getTestRequestByKey(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/tests/requests/{key}";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Iterable<TestResultSummary>>("restx-admin#SpecTestResource#findCurrentTestResults", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{TestResultSummary.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/tests/results/summaries"), HttpStatus.OK, RestxLogLevel.QUIET, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<TestResultSummary>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.findCurrentTestResults());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[TestResultSummary]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.tests.TestResultSummary";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{TestResultSummary.class});
                operation.sourceLocation = "restx.specs.SpecTestResource#findCurrentTestResults()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/tests/results/summaries";
                    }
                }).add((Object)new Verbosity(){

                    public Class<Verbosity> annotationType() {
                        return Verbosity.class;
                    }

                    public RestxLogLevel value() {
                        return RestxLogLevel.QUIET;
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, TestResult>("restx-admin#SpecTestResource#getTestResultByKey", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(TestResult.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/tests/results/{key}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"key")}){

            protected Optional<TestResult> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return resource.getTestResultByKey((String)Validations.checkValid((Optional)validator, (Object)Preconditions.checkNotNull((Object)this.mapQueryObjectFromRequest(String.class, "key", request, match, EndpointParameterKind.PATH), (Object)"PATH param <key> is required"), (Class[])new Class[0]));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription key = new OperationParameterDescription();
                key.name = "key";
                key.paramType = OperationParameterDescription.ParamType.path;
                key.dataType = "string";
                key.schemaKey = "";
                key.required = true;
                operation.parameters.add(key);
                operation.responseClass = "TestResult";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.tests.TestResult";
                operation.outEntityType = TestResult.class;
                operation.sourceLocation = "restx.specs.SpecTestResource#getTestResultByKey(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/tests/results/{key}";
                    }
                }).build();
            }
        }});
    }
}

