/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.google.common.collect.ImmutableMap;
import restx.common.ThreadLocalMillisProvider;
import restx.factory.AutoStartable;
import restx.factory.Component;
import restx.factory.Factory;
import restx.specs.GivenTime;
import restx.tests.GivenCleaner;
import restx.tests.GivenRunner;
import restx.tests.NoopGivenCleaner;

@Component
public class GivenTimeRunner
implements GivenRunner<GivenTime> {
    @Override
    public Class<GivenTime> getGivenClass() {
        return GivenTime.class;
    }

    @Override
    public GivenCleaner run(GivenTime given, ImmutableMap<String, String> params) {
        Factory.LocalMachines.threadLocal().set("FixedTimeComponent", (Object)new FixedTimeComponent(given.getTime().getMillis()));
        return NoopGivenCleaner.INSTANCE;
    }

    private class FixedTimeComponent
    implements AutoStartable,
    AutoCloseable {
        private final long millis;

        public FixedTimeComponent(long millis) {
            this.millis = millis;
        }

        public void start() {
            ThreadLocalMillisProvider.setCurrentMillisFixed((long)this.millis);
        }

        @Override
        public void close() throws Exception {
            ThreadLocalMillisProvider.clear();
        }
    }
}

