/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.joda.time.DateTime;
import restx.RestxMainRouterFactory;
import restx.common.UUIDGenerator;
import restx.factory.Factory;
import restx.security.RestxSessionCookieDescriptor;
import restx.security.Signer;

public class HttpTestClient {
    private final String baseUrl;
    private final String principal;
    private final ImmutableMap<String, String> cookies;

    public static HttpTestClient withBaseUrl(String baseUrl) {
        return new HttpTestClient(baseUrl, null, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    private HttpTestClient(String baseUrl, String principal, ImmutableMap<String, String> cookies) {
        this.baseUrl = baseUrl;
        this.principal = principal;
        this.cookies = cookies;
    }

    public HttpTestClient authenticatedAs(String principal) {
        Factory factory = Factory.newInstance();
        RestxSessionCookieDescriptor restxSessionCookieDescriptor = (RestxSessionCookieDescriptor)factory.getComponent(RestxSessionCookieDescriptor.class);
        Signer signer = (Signer)factory.queryByClass(Signer.class).findOneAsComponent().get();
        ImmutableMap.Builder cookiesBuilder = ImmutableMap.builder().putAll(this.cookies);
        String uuid = ((UUIDGenerator)factory.getComponent(UUIDGenerator.class)).doGenerate();
        String expires = DateTime.now().plusHours(1).toString();
        String sessionContent = String.format("{\"_expires\":\"%s\",\"principal\":\"%s\",\"sessionKey\":\"%s\"}", expires, principal, uuid);
        cookiesBuilder.put((Object)restxSessionCookieDescriptor.getCookieName(), (Object)sessionContent);
        cookiesBuilder.put((Object)restxSessionCookieDescriptor.getCookieSignatureName(), (Object)signer.sign(sessionContent));
        return new HttpTestClient(this.baseUrl, principal, (ImmutableMap<String, String>)cookiesBuilder.build());
    }

    public HttpTestClient withCookie(String cookieName, String cookieValue) {
        return new HttpTestClient(this.baseUrl, this.principal, (ImmutableMap<String, String>)ImmutableMap.builder().putAll(this.cookies).put((Object)cookieName, (Object)cookieValue).build());
    }

    public HttpRequest http(String method, String url) {
        HttpRequest httpRequest = new HttpRequest((CharSequence)(this.baseUrl + HttpTestClient.root(url)), method).header("RestxThreadLocal", Factory.LocalMachines.threadLocal().getId()).header("RestxBlade", RestxMainRouterFactory.Blade.current());
        if (!this.cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : this.cookies.entrySet()) {
                sb.append((String)entry.getKey()).append("=\"").append(((String)entry.getValue()).replace("\"", "\\\"")).append("\"; ");
            }
            sb.setLength(sb.length() - 2);
            httpRequest.header("Cookie", sb.toString());
        }
        return httpRequest;
    }

    public HttpRequest GET(String url) {
        return this.http("GET", url);
    }

    public HttpRequest HEAD(String url) {
        return this.http("HEAD", url);
    }

    public HttpRequest OPTIONS(String url) {
        return this.http("OPTIONS", url);
    }

    public HttpRequest POST(String url) {
        return this.http("POST", url);
    }

    public HttpRequest PUT(String url) {
        return this.http("PUT", url);
    }

    public HttpRequest DELETE(String url) {
        return this.http("DELETE", url);
    }

    private static String root(String url) {
        return url.startsWith("http") || url.startsWith("/") ? url : "/" + url;
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }
}

