/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import restx.RestxMainRouterFactory;
import restx.factory.Factory;
import restx.specs.Given;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecLoader;
import restx.specs.When;
import restx.tests.GivenCleaner;
import restx.tests.GivenRunner;
import restx.tests.GivenSpecRule;
import restx.tests.GivenSpecRuleSupplier;
import restx.tests.WhenChecker;

public class RestxSpecRunner {
    private final String serverId;
    private final String baseUrl;
    private final String routerPath;
    private final RestxSpecLoader specLoader;
    private final Iterable<GivenSpecRuleSupplier> givenSpecRuleSuppliers;
    private final Iterable<GivenRunner> givenRunners;
    private final Iterable<WhenChecker> whenCheckers;
    private final Map<String, Iterable<GivenSpecRule>> givenRulesPerBlade = new LinkedHashMap<String, Iterable<GivenSpecRule>>();

    public RestxSpecRunner(RestxSpecLoader specLoader, String routerPath, String serverId, String baseUrl, Factory factory) {
        this.specLoader = (RestxSpecLoader)Preconditions.checkNotNull((Object)specLoader);
        this.routerPath = (String)Preconditions.checkNotNull((Object)routerPath);
        this.serverId = (String)Preconditions.checkNotNull((Object)serverId);
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
        this.givenSpecRuleSuppliers = factory.queryByClass(GivenSpecRuleSupplier.class).findAsComponents();
        this.givenRunners = factory.queryByClass(GivenRunner.class).findAsComponents();
        this.whenCheckers = factory.queryByClass(WhenChecker.class).findAsComponents();
    }

    public void runTest(String spec) throws IOException {
        this.runTest(this.loadSpec(spec));
    }

    public RestxSpec loadSpec(String spec) throws IOException {
        return this.specLoader.load(spec);
    }

    public void runTest(RestxSpec restxSpec) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        for (GivenSpecRule givenSpecRule : this.getSpecRulesForCurrentBlade()) {
            params.putAll(givenSpecRule.getRunParams());
        }
        params.put("WhenHttpRequest.CONTEXT_NAME", this.serverId);
        params.put("WhenHttpRequest.BASE_URL", this.baseUrl + this.routerPath);
        this.runSpec(restxSpec, (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)params));
    }

    private synchronized Iterable<GivenSpecRule> getSpecRulesForCurrentBlade() {
        String currentBlade = RestxMainRouterFactory.Blade.current();
        ArrayList givenSpecRules = this.givenRulesPerBlade.get(currentBlade);
        if (givenSpecRules == null) {
            givenSpecRules = Lists.newArrayList((Iterable)Iterables.transform(this.givenSpecRuleSuppliers, (Function)Suppliers.supplierFunction()));
            for (GivenSpecRule givenSpecRule : givenSpecRules) {
                givenSpecRule.onSetup(Factory.LocalMachines.contextLocal((String)this.bladeContextId(currentBlade)));
            }
            this.givenRulesPerBlade.put(currentBlade, givenSpecRules);
        }
        return givenSpecRules;
    }

    public synchronized void dispose() {
        for (Map.Entry<String, Iterable<GivenSpecRule>> blade : this.givenRulesPerBlade.entrySet()) {
            for (GivenSpecRule givenSpecRule : blade.getValue()) {
                givenSpecRule.onTearDown(Factory.LocalMachines.contextLocal((String)this.bladeContextId(blade.getKey())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSpec(RestxSpec restxSpec, ImmutableMap<String, String> params) {
        ArrayList givenCleaners = Lists.newArrayList();
        try {
            for (Given given : restxSpec.getGiven()) {
                Set<GivenRunner<Given>> runnersFor = this.findRunnersFor(given);
                if (runnersFor.isEmpty()) {
                    throw new IllegalStateException("no runner found for given " + given + ". double check your classpath and factory settings.");
                }
                for (GivenRunner<Given> runner : runnersFor) {
                    givenCleaners.add(runner.run(given, params));
                }
            }
            for (When when : restxSpec.getWhens()) {
                Optional<WhenChecker<When>> checkerFor = this.findCheckerFor(when);
                if (!checkerFor.isPresent()) {
                    throw new IllegalStateException("no checker found for when " + when + "." + " double check your classpath and factory settings.");
                }
                ((WhenChecker)checkerFor.get()).check(when, params);
            }
        }
        finally {
            for (GivenCleaner givenCleaner : givenCleaners) {
                givenCleaner.cleanUp();
            }
            Factory.LocalMachines.overrideComponents().clear();
        }
    }

    private <T extends When> Optional<WhenChecker<T>> findCheckerFor(T when) {
        if (when instanceof WhenChecker) {
            return Optional.of((Object)((WhenChecker)when));
        }
        for (WhenChecker whenChecker : this.whenCheckers) {
            if (!whenChecker.getWhenClass().isAssignableFrom(when.getClass())) continue;
            return Optional.of((Object)whenChecker);
        }
        return Optional.absent();
    }

    private <T extends Given> Set<GivenRunner<T>> findRunnersFor(T given) {
        if (given instanceof GivenRunner) {
            return Sets.newHashSet((Object[])new GivenRunner[]{(GivenRunner)given});
        }
        HashSet<GivenRunner<T>> compatibleRunners = new HashSet<GivenRunner<T>>();
        for (GivenRunner givenRunner : this.givenRunners) {
            if (!givenRunner.getGivenClass().isAssignableFrom(given.getClass())) continue;
            compatibleRunners.add(givenRunner);
        }
        return compatibleRunners;
    }

    protected Factory.LocalMachines bladeLocalMachines() {
        return RestxMainRouterFactory.Blade.bladeLocalMachines((String)this.serverId);
    }

    private String bladeContextId() {
        return this.bladeContextId(RestxMainRouterFactory.Blade.current());
    }

    private String bladeContextId(String bladeId) {
        return RestxMainRouterFactory.Blade.contextId((String)this.serverId, (String)bladeId);
    }
}

