/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.classloader.ClasspathResourceEvent;
import restx.classloader.CompilationFinishedEvent;
import restx.common.UUIDGenerator;
import restx.config.Settings;
import restx.config.SettingsKey;
import restx.exceptions.ErrorCode;
import restx.exceptions.RestxErrors;
import restx.factory.AutoStartable;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.NamedComponent;
import restx.factory.SingletonFactoryMachine;
import restx.server.WebServer;
import restx.server.WebServerSupplier;
import restx.specs.HotReloadRestxSpecRepository;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecLoader;
import restx.specs.RestxSpecRepository;
import restx.tests.RestxSpecRunner;
import restx.tests.TestRequest;
import restx.tests.TestResult;
import restx.tests.TestResultSummary;
import restx.tests.ThreadLocalPrintStream;

public class RestxSpecTestServer {
    private final String routerPath;
    private final int port;
    private final WebServerSupplier webServerSupplier;
    private final Factory factory;

    public static RestxSpecTestServer newInstance() {
        Factory f = Factory.getInstance();
        return new RestxSpecTestServer("/api", 8076, (WebServerSupplier)f.getComponent(WebServerSupplier.class), f);
    }

    public static RestxSpecTestServer newInstance(WebServerSupplier webServerSupplier) {
        return new RestxSpecTestServer("/api", 8076, webServerSupplier, Factory.getInstance());
    }

    public RestxSpecTestServer(String routerPath, int port, WebServerSupplier webServerSupplier, Factory factory) {
        this.routerPath = routerPath;
        this.port = port;
        this.webServerSupplier = webServerSupplier;
        this.factory = factory;
    }

    public RunningServer start() throws Exception {
        System.setProperty("restx.mode", "infinirest");
        WebServer server = this.webServerSupplier.newWebServer(this.port);
        server.start();
        RestxSpecLoader specLoader = new RestxSpecLoader(this.factory);
        RestxSpecRunner runner = new RestxSpecRunner(specLoader, this.routerPath, server.getServerId(), server.baseUrl(), this.factory);
        HotReloadRestxSpecRepository repository = new HotReloadRestxSpecRepository(specLoader);
        final RunningServer runningServer = new RunningServer(server, runner, (RestxSpecRepository)repository, (UUIDGenerator)this.factory.getComponent(UUIDGenerator.class), (RestxErrors)this.factory.getComponent(RestxErrors.class), (RunningServerSettings)this.factory.getComponent(RunningServerSettings.class));
        ((EventBus)((Factory)Factory.getFactory((String)server.getServerId()).get()).getComponent(EventBus.class)).register(new Object(){

            @Subscribe
            public void onCompilationFinished(CompilationFinishedEvent event) {
                runningServer.submitTestRequest(new TestRequest().setTest("specs/*"));
            }

            @Subscribe
            public void onResourceEvent(ClasspathResourceEvent event) {
                if (event.getResourcePath().startsWith("specs")) {
                    runningServer.submitTestRequest(new TestRequest().setTest(event.getResourcePath()));
                } else {
                    runningServer.submitTestRequest(new TestRequest().setTest("specs/*"));
                }
            }
        });
        return runningServer;
    }

    public static void main(String[] args) throws Exception {
        RestxSpecTestServer.newInstance().start();
    }

    public static class RunningServer {
        private static final Logger logger = LoggerFactory.getLogger(RunningServer.class);
        private final WebServer server;
        private final RestxSpecRunner runner;
        private final RestxSpecRepository repository;
        private final RestxErrors errors;
        private final UUIDGenerator uuidGenerator;
        private final ExecutorService testRequestExecutor = Executors.newSingleThreadExecutor();
        private final ListeningExecutorService testExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(4));
        private final Path storeLocation;
        private final ObjectMapper objectMapper;
        private final Map<String, TestResultSummary> lastResults;
        private final PrintStream sysout = System.out;
        private final PrintStream syserr = System.err;
        private final ThreadLocalPrintStream out = new ThreadLocalPrintStream(this.sysout);
        private final ThreadLocalPrintStream err = new ThreadLocalPrintStream(this.syserr);

        public RunningServer(WebServer server, RestxSpecRunner runner, RestxSpecRepository repository, UUIDGenerator uuidGenerator, RestxErrors errors, RunningServerSettings settings) {
            this.server = server;
            this.runner = runner;
            this.repository = repository;
            this.uuidGenerator = uuidGenerator;
            this.errors = errors;
            this.storeLocation = Paths.get(settings.targetTestsRoot(), new String[0]);
            this.objectMapper = new ObjectMapper();
            this.objectMapper.registerModule((Module)new JodaModule());
            this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.lastResults = this.loadLastResults();
            System.setOut(this.out);
            System.setErr(this.err);
            Factory.LocalMachines.contextLocal((String)server.getServerId()).addMachine((FactoryMachine)new SingletonFactoryMachine(0, NamedComponent.of(RunningServer.class, (String)"RunningServer", (Object)this)));
        }

        public WebServer getServer() {
            return this.server;
        }

        public void stop() throws Exception {
            this.runner.dispose();
            this.server.stop();
            System.setOut(this.sysout);
            System.setErr(this.syserr);
        }

        public TestRequest submitTestRequest(TestRequest testRequest) {
            if (testRequest.getTest().startsWith("specs")) {
                final String requestKey = this.uuidGenerator.doGenerate();
                logger.info("queuing test request {}", (Object)testRequest);
                testRequest.setKey(requestKey);
                testRequest.setRequestTime(DateTime.now());
                testRequest.setStatus(TestRequest.Status.QUEUED);
                this.store(testRequest);
                this.testRequestExecutor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Optional<TestRequest> requestOptional = RunningServer.this.getRequestByKey(requestKey);
                        if (!requestOptional.isPresent()) {
                            logger.warn("test request not found when trying to execute it: {}", (Object)requestKey);
                            return;
                        }
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        TestRequest testRequest = (TestRequest)requestOptional.get();
                        logger.info("running test request {}", (Object)testRequest);
                        testRequest.setStatus(TestRequest.Status.RUNNING);
                        RunningServer.this.store(testRequest);
                        ArrayList<ListenableFuture> futureResultKeys = new ArrayList<ListenableFuture>();
                        String spec = testRequest.getTest();
                        if (spec.endsWith("*")) {
                            if (spec.equals("specs/*")) {
                                Map map = RunningServer.this.lastResults;
                                synchronized (map) {
                                    RunningServer.this.lastResults.clear();
                                }
                            }
                            String prefix = spec.substring(0, spec.length() - 1);
                            for (String s : RunningServer.this.repository.findAll()) {
                                if (!s.startsWith(prefix)) continue;
                                futureResultKeys.add(RunningServer.this.testExecutor.submit(RunningServer.this.runSpecTest(s)));
                            }
                        } else {
                            futureResultKeys.add(RunningServer.this.testExecutor.submit(RunningServer.this.runSpecTest(spec)));
                        }
                        List resultKeys = (List)Futures.getUnchecked((Future)Futures.allAsList(futureResultKeys));
                        testRequest.setStatus(TestRequest.Status.DONE);
                        testRequest.setTestResultKey(Joiner.on((String)",").join((Iterable)resultKeys));
                        RunningServer.this.store(testRequest);
                        logger.info("completed test request {} in {}: {}", new Object[]{testRequest.getKey(), stopwatch.stop(), testRequest});
                    }
                });
                return testRequest;
            }
            throw this.errors.on(Rules.InvalidTest.class).set((Object)Rules.InvalidTest.TEST, testRequest.getTest()).set((Object)Rules.InvalidTest.DESCRIPTION, "can only run spec test, test field must start with 'specs'").raise();
        }

        private Callable<String> runSpecTest(final String spec) {
            return new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    logger.info("spec test {} >> STARTING", (Object)spec);
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    PrintStream outPrintStream = new PrintStream(outStream);
                    RunningServer.this.out.setCurrent(outPrintStream);
                    ByteArrayOutputStream errStream = new ByteArrayOutputStream();
                    PrintStream errPrintStream = new PrintStream(errStream);
                    RunningServer.this.err.setCurrent(errPrintStream);
                    Factory.LocalMachines.threadLocal().set("OutPrintStreamComponent", (Object)new LocalStreamComponent(RunningServer.this.out, outPrintStream)).set("ErrPrintStreamComponent", (Object)new LocalStreamComponent(RunningServer.this.err, errPrintStream));
                    TestResultSummary.Status status = TestResultSummary.Status.ERROR;
                    long start = System.currentTimeMillis();
                    try {
                        RunningServer.this.runner.runTest((RestxSpec)RunningServer.this.repository.findSpecById(spec).get());
                        status = TestResultSummary.Status.SUCCESS;
                    }
                    catch (AssertionError e) {
                        status = TestResultSummary.Status.FAILURE;
                        System.err.println(((Throwable)((Object)e)).getMessage());
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                    finally {
                        RunningServer.this.out.clearCurrent();
                        RunningServer.this.err.clearCurrent();
                    }
                    TestResult result = new TestResult().setSummary(new TestResultSummary().setKey(RunningServer.this.uuidGenerator.doGenerate()).setName(spec).setStatus(status).setTestDuration(System.currentTimeMillis() - start).setTestTime(new DateTime(start))).setStdOut(new String(outStream.toByteArray())).setStdErr(new String(errStream.toByteArray()));
                    RunningServer.this.store(result);
                    logger.info("spec test {} >> END {}", (Object)spec, (Object)stopWatch);
                    return result.getSummary().getKey();
                }
            };
        }

        private void store(TestRequest testRequest) {
            try {
                File file = this.testRequestFile(testRequest.getKey());
                file.getParentFile().mkdirs();
                this.objectMapper.writeValue(file, (Object)testRequest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Optional<TestRequest> getRequestByKey(String key) {
            File file = this.testRequestFile(key);
            if (!file.exists()) {
                return Optional.absent();
            }
            try {
                TestRequest testRequest = (TestRequest)this.objectMapper.readValue(file, TestRequest.class);
                return Optional.of((Object)testRequest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private File testRequestFile(String key) {
            return this.storeLocation.resolve("requests/" + key + ".json").toFile();
        }

        private Map<String, TestResultSummary> loadLastResults() {
            HashMap<String, TestResultSummary> results = new HashMap<String, TestResultSummary>();
            File src = this.lastResultSummariesFile();
            if (!src.exists()) {
                return results;
            }
            try {
                Collection summaries = (Collection)this.objectMapper.readValue(src, (TypeReference)new TypeReference<Collection<TestResultSummary>>(){});
                for (TestResultSummary summary : summaries) {
                    results.put(summary.getName(), summary);
                }
            }
            catch (IOException e) {
                logger.error("error reading last result summaries file - will start with empty data", (Throwable)e);
                results.clear();
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store(TestResult result) {
            try {
                String key = result.getSummary().getKey();
                File resultFile = this.testResultSummaryFile(key);
                resultFile.getParentFile().mkdirs();
                Files.write((CharSequence)result.getStdOut(), (File)this.testResultStdOutFile(key), (Charset)Charsets.UTF_8);
                Files.write((CharSequence)result.getStdErr(), (File)this.testResultStdErrFile(key), (Charset)Charsets.UTF_8);
                this.objectMapper.writeValue(resultFile, (Object)result.getSummary());
                Map<String, TestResultSummary> map = this.lastResults;
                synchronized (map) {
                    this.lastResults.put(result.getSummary().getName(), result.getSummary());
                    this.testRequestExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RunningServer.this.objectMapper.writeValue(RunningServer.this.lastResultSummariesFile(), RunningServer.this.lastResults.values());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Optional<TestResult> getResultByKey(String key) {
            File file = this.testResultSummaryFile(key);
            if (!file.exists()) {
                return Optional.absent();
            }
            try {
                TestResult testResult = new TestResult().setSummary((TestResultSummary)this.objectMapper.readValue(file, TestResultSummary.class)).setStdOut(Files.toString((File)this.testResultStdOutFile(key), (Charset)Charsets.UTF_8)).setStdErr(Files.toString((File)this.testResultStdErrFile(key), (Charset)Charsets.UTF_8));
                return Optional.of((Object)testResult);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private File lastResultSummariesFile() {
            return this.storeLocation.resolve("results/last.summaries.json").toFile();
        }

        private File testResultStdOutFile(String key) {
            return this.storeLocation.resolve("results/" + key + ".stdout.txt").toFile();
        }

        private File testResultStdErrFile(String key) {
            return this.storeLocation.resolve("results/" + key + ".stderr.txt").toFile();
        }

        private File testResultSummaryFile(String key) {
            return this.storeLocation.resolve("results/" + key + ".summary.json").toFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<TestResultSummary> findCurrentTestResults() {
            Map<String, TestResultSummary> map = this.lastResults;
            synchronized (map) {
                return new ArrayList<TestResultSummary>(this.lastResults.values());
            }
        }

        private static class LocalStreamComponent
        implements AutoStartable,
        AutoCloseable {
            private final ThreadLocalPrintStream localPrintStream;
            private final PrintStream stream;

            private LocalStreamComponent(ThreadLocalPrintStream localPrintStream, PrintStream stream) {
                this.localPrintStream = localPrintStream;
                this.stream = stream;
            }

            public void start() {
                this.localPrintStream.setCurrent(this.stream);
            }

            @Override
            public void close() throws Exception {
                this.localPrintStream.clearCurrent();
            }
        }

        public static class Rules {

            @ErrorCode(code="TEST-001", description="invalid test")
            public static enum InvalidTest {
                TEST,
                DESCRIPTION;

            }
        }
    }

    @Settings
    public static interface RunningServerSettings {
        @SettingsKey(key="restx.targetTestsRoot", defaultValue="target/restx/tests")
        public String targetTestsRoot();
    }
}

