/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import restx.specs.RestxSpec;
import restx.tests.FindSpecsIn;
import restx.tests.RestxSpecRule;
import restx.tests.RestxSpecTests;

public class RestxSpecTestsRunner
extends ParentRunner<RestxSpec> {
    private final RestxSpecTests tests;

    public RestxSpecTestsRunner(Class<?> testClass) throws InitializationError, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException, IOException {
        super(testClass);
        FindSpecsIn findSpecsIn = this.getTestClass().getJavaClass().getAnnotation(FindSpecsIn.class);
        if (findSpecsIn != null) {
            this.tests = new RestxSpecTests(new RestxSpecRule(findSpecsIn.withRouterPath()), RestxSpecTests.findSpecsIn(findSpecsIn.value()));
        } else {
            Object o = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
            if (!(o instanceof RestxSpecTests)) {
                throw new IllegalArgumentException(String.format("Test class %s must either be annotated with FindSpecsIn or extend RestxSpecTests to be run with RestxSpecTestsRunner.", this.getTestClass().getJavaClass().getName()));
            }
            this.tests = (RestxSpecTests)o;
        }
    }

    protected List<RestxSpec> getChildren() {
        return this.tests.getSpecs();
    }

    protected Description describeChild(RestxSpec child) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.getTitle());
    }

    protected List<TestRule> classRules() {
        List rules = super.classRules();
        rules.add(this.tests.getRule());
        return rules;
    }

    protected void runChild(final RestxSpec restxSpec, RunNotifier notifier) {
        Description description = this.describeChild(restxSpec);
        this.runLeaf(new Statement(){

            public void evaluate() throws Throwable {
                RestxSpecTestsRunner.this.tests.getRule().runTest(restxSpec);
            }
        }, description, notifier);
    }
}

