/*
 * Decompiled with CFR 0.152.
 */
package restx.tests.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.io.Files;
import com.samskivert.mustache.Template;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import restx.common.MoreStrings;
import restx.common.Mustaches;
import restx.tests.json.FileJsonSource;
import restx.tests.json.JsonDiff;
import restx.tests.json.JsonDiffComparator;
import restx.tests.json.JsonDiffer;
import restx.tests.json.JsonMerger;
import restx.tests.json.JsonObjectLocation;
import restx.tests.json.JsonSource;
import restx.tests.json.StringJsonSource;
import restx.tests.json.URLJsonSource;

public class JsonAssertions {
    private final JsonDiffer differ;
    private final JsonSource actual;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean allowingExtraUnexpectedFields;
    private int contentLengthHtmlReportThreshold = 600;

    public static JsonAssertions assertThat(String json) {
        return new JsonAssertions(new StringJsonSource("actual", json));
    }

    public static JsonAssertions assertThat(File json, Charset cs) {
        return new JsonAssertions(new FileJsonSource(json, cs));
    }

    public static JsonAssertions assertThat(URL json, Charset cs) {
        return new JsonAssertions(new URLJsonSource(json, cs));
    }

    public static JsonAssertions assertThat(JsonSource json) {
        return new JsonAssertions(json);
    }

    private JsonAssertions(JsonSource actual) {
        this.actual = actual;
        this.differ = new JsonDiffer();
    }

    public JsonAssertions allowingExtraUnexpectedFields() {
        this.allowingExtraUnexpectedFields = true;
        this.differ.getLeftConfig().setIgnoreExtraFields(true);
        return this;
    }

    public JsonAssertions withJsonDiffComparator(JsonDiffComparator jsonDiffComparator) {
        this.differ.setJsonDiffComparator(jsonDiffComparator);
        return this;
    }

    public JsonAssertions withContentLengthHtmlReportThreshold(int contentLengthHtmlReportThreshold) {
        this.contentLengthHtmlReportThreshold = contentLengthHtmlReportThreshold;
        return this;
    }

    public JsonAssertions isSameJsonAs(String expected) {
        return this.isSameJsonAs(new StringJsonSource("expected", expected));
    }

    public JsonAssertions isSameJsonAs(File expected, Charset cs) {
        return this.isSameJsonAs(new FileJsonSource(expected, cs));
    }

    public JsonAssertions isSameJsonAs(URL expected, Charset cs) {
        return this.isSameJsonAs(new URLJsonSource(expected, cs));
    }

    public JsonAssertions isSameJsonAs(JsonSource expected) {
        JsonDiff diff = this.differ.compare(this.actual, expected);
        if (!diff.isSame()) {
            if (expected.content().length() < this.contentLengthHtmlReportThreshold && this.actual.content().length() < this.contentLengthHtmlReportThreshold) {
                throw new AssertionError((Object)this.fullTextReport(expected, diff).toString());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Expecting:\n").append(MoreStrings.indent((String)this.limit(this.actual.content(), this.contentLengthHtmlReportThreshold), (int)2)).append("\n").append("\nto be same json as:\n").append(MoreStrings.indent((String)this.limit(expected.content(), this.contentLengthHtmlReportThreshold), (int)2)).append("\n").append("\nbut following differences were found:\n\n");
            int i = 1;
            for (JsonDiff.Difference difference : diff.getDifferences()) {
                this.appendDifferenceInfo(i, sb, difference);
                ++i;
            }
            try {
                File htmlReport = File.createTempFile("json-diff", ".html");
                ArrayList<ImmutableMap> differences = new ArrayList<ImmutableMap>();
                ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
                i = 1;
                for (JsonDiff.Difference difference : diff.getDifferences()) {
                    String expectedContextPath;
                    String expectedKeyOfInterest;
                    String actualContextPath;
                    String actualKeyOfInterest;
                    StringBuilder diffSb = new StringBuilder();
                    this.appendDifferenceInfo(i, diffSb, difference);
                    if (difference instanceof JsonDiff.AddedKey) {
                        actualKeyOfInterest = "";
                        actualContextPath = difference.getLeftPath();
                        expectedKeyOfInterest = ((JsonDiff.AddedKey)difference).getKey();
                        expectedContextPath = difference.getRightPath();
                    } else if (difference instanceof JsonDiff.RemovedKey) {
                        actualKeyOfInterest = ((JsonDiff.RemovedKey)difference).getKey();
                        actualContextPath = difference.getLeftPath();
                        expectedKeyOfInterest = "";
                        expectedContextPath = difference.getRightPath();
                    } else {
                        actualKeyOfInterest = diff.getLastElementPath(difference.getLeftPath());
                        expectedKeyOfInterest = diff.getLastElementPath(difference.getRightPath());
                        actualContextPath = diff.getParentPath(difference.getLeftPath());
                        expectedContextPath = diff.getParentPath(difference.getRightPath());
                    }
                    differences.add(ImmutableMap.builder().put((Object)"number", (Object)String.valueOf(i)).put((Object)"difference", (Object)diffSb.toString().replace("\"", "\\\"").replace("\n", "\\n")).put((Object)"actual-path", (Object)difference.getLeftPath()).put((Object)"actual-keyOfInterest", (Object)actualKeyOfInterest).put((Object)"actual-context", (Object)objectWriter.writeValueAsString(this.toContext(diff.getLeftAt(actualContextPath), actualKeyOfInterest)).replace("\"", "\\\"").replace("\n", "\\n")).put((Object)"expected-path", (Object)difference.getRightPath()).put((Object)"expected-keyOfInterest", (Object)expectedKeyOfInterest).put((Object)"expected-context", (Object)objectWriter.writeValueAsString(this.toContext(diff.getRightAt(expectedContextPath), expectedKeyOfInterest)).replace("\"", "\\\"").replace("\n", "\\n")).build());
                    ++i;
                }
                String r = Mustaches.execute((Template)Mustaches.compile(JsonAssertions.class, (String)"json-diff.html"), (Object)ImmutableMap.of((Object)"actual", (Object)this.actual.content(), (Object)"expected", (Object)expected.content(), (Object)"diff", (Object)diff, (Object)"differences", differences, (Object)"fix-expected", (Object)new JsonMerger().mergeToRight(diff)));
                Files.write((CharSequence)r, (File)htmlReport, (Charset)Charsets.UTF_8);
                sb.append("\n\nA detailed HTML REPORT has been generated in ").append(htmlReport.toURI().toURL()).append("\n");
            }
            catch (IOException e) {
                sb.append("\n\nERROR occured when generating html report: " + e + "\n\n");
            }
            throw new AssertionError((Object)sb.toString());
        }
        return this;
    }

    private Object toContext(Object o, String keyOfInterest) {
        if (o instanceof Map) {
            Map map = (Map)o;
            LinkedHashMap context = new LinkedHashMap();
            for (String key : map.keySet()) {
                Object v = map.get(key);
                if (key.equals(keyOfInterest)) {
                    context.put(key, v);
                    continue;
                }
                if (v instanceof Map) {
                    context.put(key, "/object with " + ((Map)v).size() + " entries/");
                    continue;
                }
                if (v instanceof List) {
                    context.put(key, "/array with " + ((List)v).size() + " entries/");
                    continue;
                }
                context.put(key, v);
            }
            return context;
        }
        return o;
    }

    private String limit(String s, int threshold) {
        if (s.length() <= threshold) {
            return s;
        }
        return s.substring(0, threshold) + "[...]\n[" + (s.length() - threshold) + " chars stripped]";
    }

    protected StringBuilder fullTextReport(JsonSource expected, JsonDiff diff) {
        StringBuilder sb = new StringBuilder();
        sb.append("Expecting:\n").append(MoreStrings.indent((String)this.actual.content(), (int)2)).append("\n").append("to be same json as:\n").append(MoreStrings.indent((String)expected.content(), (int)2)).append("\n").append("but following differences were found:\n");
        LinkedListMultimap differencesPerLocation = LinkedListMultimap.create();
        for (JsonDiff.Difference difference : diff.getDifferences()) {
            differencesPerLocation.put((Object)difference.getLeftContext(), (Object)difference);
        }
        int i = 1;
        for (JsonObjectLocation context : differencesPerLocation.keySet()) {
            sb.append(String.format("- within [L%dC%d]-[L%dC%d]:\n", context.getFrom().getLineNr(), context.getFrom().getColumnNr(), context.getTo().getLineNr(), context.getTo().getColumnNr())).append(MoreStrings.indent((String)context.getJson(), (int)2)).append("\n");
            for (JsonDiff.Difference difference : differencesPerLocation.get((Object)context)) {
                this.appendDifferenceInfo(i, sb, difference);
                ++i;
            }
        }
        if (this.allowingExtraUnexpectedFields) {
            sb.append("\n\nif the expectation is not up to date, here is a merged expect that you can use to fix your test:\n");
            sb.append(MoreStrings.indent((String)new JsonMerger().mergeToRight(diff), (int)2)).append("\n\n");
        }
        return sb;
    }

    private void appendDifferenceInfo(int i, StringBuilder sb, JsonDiff.Difference difference) {
        if (difference instanceof JsonDiff.AddedKey) {
            JsonDiff.AddedKey addedKey = (JsonDiff.AddedKey)difference;
            sb.append(String.format("%02d) ", i)).append("missing key '").append(addedKey.getKey()).append("'").append(" at path '").append(addedKey.getLeftPath()).append("'").append(" expected value:\n").append(MoreStrings.indent((String)this.asJson(addedKey.getValue()), (int)6)).append("\n");
        }
        if (difference instanceof JsonDiff.RemovedKey) {
            JsonDiff.RemovedKey removedKey = (JsonDiff.RemovedKey)difference;
            sb.append(String.format("%02d) ", i)).append("extra key '").append(removedKey.getKey()).append("'").append(" at path '").append(removedKey.getLeftPath()).append("'").append(" with value:\n").append(MoreStrings.indent((String)this.asJson(removedKey.getValue()), (int)6)).append("\n");
        }
        if (difference instanceof JsonDiff.ValueDiff) {
            JsonDiff.ValueDiff valueDiff = (JsonDiff.ValueDiff)difference;
            sb.append(String.format("%02d) ", i)).append("expected value ").append(this.asJson(valueDiff.getRightValue())).append(" but was ").append(this.asJson(valueDiff.getLeftValue())).append(" at path '").append(valueDiff.getLeftPath()).append("'\n");
        }
        if (difference instanceof JsonDiff.ArrayInsertedValue) {
            JsonDiff.ArrayInsertedValue arrayInsertedValue = (JsonDiff.ArrayInsertedValue)difference;
            sb.append(String.format("%02d) ", i)).append("missing element(s) in array at position ").append(arrayInsertedValue.getLeftPosition()).append(" at path '").append(arrayInsertedValue.getLeftPath()).append("'").append(" expected value(s):\n").append(MoreStrings.indent((String)this.asJson(arrayInsertedValue.getValues()), (int)6)).append("\n");
        }
        if (difference instanceof JsonDiff.ArrayDeletedValue) {
            JsonDiff.ArrayDeletedValue arrayDeletedValue = (JsonDiff.ArrayDeletedValue)difference;
            sb.append(String.format("%02d) ", i)).append("extra element(s) in array at position ").append(arrayDeletedValue.getLeftPosition()).append(" at path '").append(arrayDeletedValue.getLeftPath()).append("'").append(" with value(s):\n").append(MoreStrings.indent((String)this.asJson(arrayDeletedValue.getValues()), (int)6)).append("\n");
        }
    }

    private String asJson(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return o.toString();
        }
    }
}

