/*
 * Decompiled with CFR 0.152.
 */
package restx.tests.json;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import difflib.myers.Equalizer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import restx.tests.json.JsonDiff;
import restx.tests.json.JsonDiffComparator;
import restx.tests.json.JsonSource;
import restx.tests.json.JsonWithLocationsParser;

public class JsonDiffer {
    public static final JsonDiffComparator DEFAULT_JSON_DIFF_COMPARATOR = new JsonDiffComparator(){

        @Override
        public boolean compare(JsonDiff diff, Object o1, Object o2) {
            return Objects.equal((Object)o1, (Object)o2);
        }
    };
    private Config leftConfig = new Config();
    private Config rightConfig = new Config();
    private JsonDiffComparator jsonDiffComparator = DEFAULT_JSON_DIFF_COMPARATOR;

    public Config getLeftConfig() {
        return this.leftConfig;
    }

    public Config getRightConfig() {
        return this.rightConfig;
    }

    public JsonDiffer setJsonDiffComparator(JsonDiffComparator jsonDiffComparator) {
        this.jsonDiffComparator = (JsonDiffComparator)Preconditions.checkNotNull((Object)jsonDiffComparator);
        return this;
    }

    public JsonDiff compare(JsonSource left, JsonSource right) {
        try {
            JsonWithLocationsParser.ParsedJsonWithLocations leftObj = new JsonWithLocationsParser().parse(left, Object.class);
            JsonWithLocationsParser.ParsedJsonWithLocations rightObj = new JsonWithLocationsParser().parse(right, Object.class);
            return this.diff(new JsonDiff(leftObj, rightObj), leftObj.getRoot(), rightObj.getRoot());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonDiff diff(JsonDiff diff, Object o1, Object o2) {
        if (o1 instanceof Map && o2 instanceof Map) {
            this.diffMaps(diff, (Map)o1, (Map)o2);
        } else if (o1 instanceof List && o2 instanceof List) {
            this.diffLists(diff, (List)o1, (List)o2);
        } else if (!this.jsonDiffComparator.compare(diff, o1, o2)) {
            diff.addDifference(new JsonDiff.ValueDiff(diff.currentLeftPath(), diff.currentRightPath(), diff.currentLeftContextLocation(), diff.currentRightContextLocation(), o1, o2));
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffLists(final JsonDiff diff, List<Object> o1, List<Object> o2) {
        Patch lDiff = DiffUtils.diff(o1, o2, (Equalizer)new Equalizer<Object>(){

            public boolean equals(Object o1, Object o2) {
                return JsonDiffer.this.diff(new JsonDiff(diff.getLeftObj(), diff.getRightObj()), o1, o2).isSame();
            }
        });
        for (Delta objectDelta : lDiff.getDeltas()) {
            switch (objectDelta.getType()) {
                case INSERT: {
                    diff.addDifference(new JsonDiff.ArrayInsertedValue(diff.currentLeftPath(), diff.currentRightPath(), diff.currentLeftContextLocation(), diff.currentRightContextLocation(), objectDelta.getOriginal().getPosition(), objectDelta.getRevised().getPosition(), objectDelta.getRevised().getLines()));
                    break;
                }
                case DELETE: {
                    diff.addDifference(new JsonDiff.ArrayDeletedValue(diff.currentLeftPath(), diff.currentRightPath(), diff.currentLeftContextLocation(), diff.currentRightContextLocation(), objectDelta.getOriginal().getPosition(), objectDelta.getRevised().getPosition(), objectDelta.getOriginal().getLines()));
                    break;
                }
                case CHANGE: {
                    int leftPosition = objectDelta.getOriginal().getPosition();
                    int rightPosition = objectDelta.getRevised().getPosition();
                    int changed = Math.min(objectDelta.getOriginal().getLines().size(), objectDelta.getRevised().getLines().size());
                    for (int i = 0; i < changed; ++i) {
                        Object left = o1.get(leftPosition + i);
                        Object right = o2.get(rightPosition + i);
                        try {
                            this.diff(diff.goIn("[" + (leftPosition + i) + "]", "[" + (rightPosition + i) + "]").putContexts(new JsonDiff.ListSetter(o1, leftPosition + i), left, new JsonDiff.ListSetter(o2, rightPosition + i), right), left, right);
                            continue;
                        }
                        finally {
                            diff.goUp();
                        }
                    }
                    if (objectDelta.getOriginal().getLines().size() > changed) {
                        diff.addDifference(new JsonDiff.ArrayDeletedValue(diff.currentLeftPath(), diff.currentRightPath(), diff.currentLeftContextLocation(), diff.currentRightContextLocation(), leftPosition + changed, rightPosition + changed, o1.subList(leftPosition + changed, leftPosition + objectDelta.getOriginal().getLines().size())));
                    }
                    if (objectDelta.getRevised().getLines().size() <= changed) break;
                    diff.addDifference(new JsonDiff.ArrayInsertedValue(diff.currentLeftPath(), diff.currentRightPath(), diff.currentLeftContextLocation(), diff.currentRightContextLocation(), leftPosition + changed, rightPosition + changed, o2.subList(rightPosition + changed, rightPosition + objectDelta.getRevised().getLines().size())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffMaps(JsonDiff diff, Map<String, Object> m1, Map<String, Object> m2) {
        if (!this.leftConfig.isIgnoreExtraFields()) {
            for (String k : Sets.difference(m1.keySet(), m2.keySet())) {
                diff.addDifference(new JsonDiff.RemovedKey(diff.currentLeftPath(), diff.currentRightPath(), diff.contextLeft(m1), diff.contextRight(m2), k, m1.get(k)));
            }
        }
        if (!this.rightConfig.isIgnoreExtraFields()) {
            for (String k : Sets.difference(m2.keySet(), m1.keySet())) {
                diff.addDifference(new JsonDiff.AddedKey(diff.currentLeftPath(), diff.currentRightPath(), diff.contextLeft(m1), diff.contextRight(m2), k, m2.get(k)));
            }
        }
        for (String k : Sets.intersection(m1.keySet(), m2.keySet())) {
            try {
                this.diff(diff.goIn(k).putContexts(new JsonDiff.MapSetter(m1, k), m1.get(k), new JsonDiff.MapSetter(m2, k), m2.get(k)), m1.get(k), m2.get(k));
            }
            finally {
                diff.goUp();
            }
        }
    }

    public static class Config {
        private boolean ignoreExtraFields = false;

        public boolean isIgnoreExtraFields() {
            return this.ignoreExtraFields;
        }

        public Config setIgnoreExtraFields(boolean ignoreExtraFields) {
            this.ignoreExtraFields = ignoreExtraFields;
            return this;
        }
    }
}

