/*
 * Decompiled with CFR 0.152.
 */
package restx.tests.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import restx.tests.json.FileJsonSource;
import restx.tests.json.JsonObjectLocation;
import restx.tests.json.JsonSource;
import restx.tests.json.StringJsonSource;
import restx.tests.json.URLJsonSource;

public class JsonWithLocationsParser {
    public ParsedJsonWithLocations parse(File file, Charset cs, Class type) throws IOException {
        return this.parse(new FileJsonSource(file, cs), type);
    }

    public ParsedJsonWithLocations parse(URL url, Charset cs, Class type) throws IOException {
        return this.parse(new URLJsonSource(url, cs), type);
    }

    public ParsedJsonWithLocations parse(String content, Class type) throws IOException {
        return this.parse(new StringJsonSource("", content), type);
    }

    public ParsedJsonWithLocations parse(JsonSource source, Class type) throws IOException {
        String content = source.content();
        ParsedJsonLocations locations = new ParsedJsonLocations(content);
        Object o = this.reader(locations, type).readValue(content);
        return new ParsedJsonWithLocations(locations, o);
    }

    protected ObjectReader reader(final ParsedJsonLocations locations, Class type) {
        SimpleModule module = new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new ContextualLocationDeserializerWrapper(locations, super.modifyDeserializer(config, beanDesc, deserializer));
            }

            public JsonDeserializer<?> modifyArrayDeserializer(DeserializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new ContextualLocationDeserializerWrapper(locations, super.modifyArrayDeserializer(config, valueType, beanDesc, deserializer));
            }

            public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new ContextualLocationDeserializerWrapper(locations, super.modifyMapDeserializer(config, type, beanDesc, deserializer));
            }
        });
        return new ObjectMapper().registerModule((Module)module).reader(type);
    }

    private static class LocationDeserializerWrapper
    extends JsonDeserializer
    implements ResolvableDeserializer {
        protected final ParsedJsonLocations locations;
        private final JsonDeserializer deserializer;
        private final ResolvableDeserializer resolvableDeserializer;

        private LocationDeserializerWrapper(ParsedJsonLocations locations, JsonDeserializer deserializer) {
            this.locations = locations;
            this.deserializer = deserializer;
            this.resolvableDeserializer = deserializer instanceof ResolvableDeserializer ? (ResolvableDeserializer)deserializer : null;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonLocation currentLocation = jp.getCurrentLocation();
            Object o = this.deserializer.deserialize(jp, ctxt);
            this.locations.addLocation(o, currentLocation, jp.getCurrentLocation());
            return o;
        }

        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            if (this.resolvableDeserializer != null) {
                this.resolvableDeserializer.resolve(ctxt);
            }
        }
    }

    private static class ContextualLocationDeserializerWrapper
    extends LocationDeserializerWrapper
    implements ContextualDeserializer,
    ResolvableDeserializer {
        private final ContextualDeserializer contextualDeserializer;

        private ContextualLocationDeserializerWrapper(ParsedJsonLocations locations, JsonDeserializer deserializer) {
            super(locations, deserializer);
            this.contextualDeserializer = deserializer instanceof ContextualDeserializer ? (ContextualDeserializer)deserializer : null;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            if (this.contextualDeserializer != null) {
                return new LocationDeserializerWrapper(this.locations, this.contextualDeserializer.createContextual(ctxt, property));
            }
            return this;
        }
    }

    public static class ParsedJsonWithLocations {
        private final ParsedJsonLocations locations;
        private final Object root;

        public ParsedJsonWithLocations(ParsedJsonLocations locations, Object root) {
            this.locations = locations;
            this.root = root;
        }

        public ParsedJsonLocations getLocations() {
            return this.locations;
        }

        public Object getRoot() {
            return this.root;
        }

        public String toString() {
            return "ParsedJsonWithLocations{locations=" + this.locations + ", root=" + this.root + '}';
        }
    }

    public static class ParsedJsonLocations {
        private final String source;
        private Map<Object, JsonObjectLocation> locations = new HashMap<Object, JsonObjectLocation>();

        public ParsedJsonLocations(String source) {
            this.source = source;
        }

        private void addLocation(Object o, JsonLocation from, JsonLocation to) {
            this.locations.put(this.objectKey(o), new JsonObjectLocation(this.source, from, to));
        }

        protected String objectKey(Object o) {
            return System.identityHashCode(o) + "-" + o;
        }

        public Optional<JsonObjectLocation> getLocationOf(Object o) {
            return Optional.fromNullable((Object)this.locations.get(this.objectKey(o)));
        }

        public String toString() {
            return "ParsedJsonLocations{locations=" + this.locations + '}';
        }
    }
}

