/*
 * Decompiled with CFR 0.152.
 */
package restx.validation;

import javax.inject.Named;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import restx.factory.Module;
import restx.factory.Name;
import restx.factory.Provides;

@Module
public class ValidatorFactory {
    public static final String VALIDATOR_NAME = "hibernate.validator";
    public static final String IGNORE_XML_CONFIGURATION_NAME = "hibernate.validator.ignore.xml.configuration";
    public static final Name<Validator> VALIDATOR = Name.of(Validator.class, (String)"hibernate.validator");

    @Named(value="hibernate.validator")
    @Provides
    public Validator validator(@Named(value="hibernate.validator.ignore.xml.configuration") Boolean ignoreXmlConfiguration) {
        HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        if (ignoreXmlConfiguration.booleanValue()) {
            config.ignoreXmlConfiguration();
        }
        return config.buildValidatorFactory().getValidator();
    }

    @Named(value="hibernate.validator.ignore.xml.configuration")
    @Provides
    public Boolean ignoreXmlConfigurationFlag() {
        return Boolean.TRUE;
    }
}

