package restx.validation;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.validation.ValidatorFactory;


@Machine
public class ValidatorFactoryFactoryMachine extends DefaultFactoryMachine {
    private static final ValidatorFactory module = new ValidatorFactory();

    public ValidatorFactoryFactoryMachine() {
        super(0, new MachineEngine[] {
            new StdMachineEngine<javax.validation.Validator>(Name.of(javax.validation.Validator.class, "hibernate.validator"), 0, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<java.lang.Boolean> ignoreXmlConfiguration = Factory.Query.byName(Name.of(java.lang.Boolean.class, "hibernate.validator.ignore.xml.configuration")).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        ignoreXmlConfiguration
                    ));
                }

                @Override
                public javax.validation.Validator doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.validator(
	        satisfiedBOM.getOne(ignoreXmlConfiguration).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<java.lang.Boolean>(Name.of(java.lang.Boolean.class, "hibernate.validator.ignore.xml.configuration"), 0, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public java.lang.Boolean doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.ignoreXmlConfigurationFlag(
	        
	                    );
                }
            },

        });
    }
}
