/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.CheckoutActions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckoutActions.CheckoutResult", generator="Immutables")
@Immutable
public final class ImmutableCheckoutResult
implements CheckoutActions.CheckoutResult {
    private final String gid;
    private final String repo;
    private final String commit;
    private final LocalDateTime modified;
    private final String name;
    private final String value;

    private ImmutableCheckoutResult(String gid, String repo, String commit, LocalDateTime modified, String name, String value) {
        this.gid = gid;
        this.repo = repo;
        this.commit = commit;
        this.modified = modified;
        this.name = name;
        this.value = value;
    }

    @Override
    public String getGid() {
        return this.gid;
    }

    @Override
    public String getRepo() {
        return this.repo;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public LocalDateTime getModified() {
        return this.modified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public final ImmutableCheckoutResult withGid(String value) {
        String newValue = Objects.requireNonNull(value, "gid");
        if (this.gid.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckoutResult(newValue, this.repo, this.commit, this.modified, this.name, this.value);
    }

    public final ImmutableCheckoutResult withRepo(String value) {
        String newValue = Objects.requireNonNull(value, "repo");
        if (this.repo.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckoutResult(this.gid, newValue, this.commit, this.modified, this.name, this.value);
    }

    public final ImmutableCheckoutResult withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckoutResult(this.gid, this.repo, newValue, this.modified, this.name, this.value);
    }

    public final ImmutableCheckoutResult withModified(LocalDateTime value) {
        if (this.modified == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "modified");
        return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, newValue, this.name, this.value);
    }

    public final ImmutableCheckoutResult withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, this.modified, newValue, this.value);
    }

    public final ImmutableCheckoutResult withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, this.modified, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckoutResult && this.equalTo((ImmutableCheckoutResult)another);
    }

    private boolean equalTo(ImmutableCheckoutResult another) {
        return this.gid.equals(another.gid) && this.repo.equals(another.repo) && this.commit.equals(another.commit) && this.modified.equals(another.modified) && this.name.equals(another.name) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.gid.hashCode();
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CheckoutResult").omitNullValues().add("gid", (Object)this.gid).add("repo", (Object)this.repo).add("commit", (Object)this.commit).add("modified", (Object)this.modified).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }

    public static ImmutableCheckoutResult copyOf(CheckoutActions.CheckoutResult instance) {
        if (instance instanceof ImmutableCheckoutResult) {
            return (ImmutableCheckoutResult)instance;
        }
        return ImmutableCheckoutResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckoutActions.CheckoutResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GID = 1L;
        private static final long INIT_BIT_REPO = 2L;
        private static final long INIT_BIT_COMMIT = 4L;
        private static final long INIT_BIT_MODIFIED = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_VALUE = 32L;
        private long initBits = 63L;
        @Nullable
        private String gid;
        @Nullable
        private String repo;
        @Nullable
        private String commit;
        @Nullable
        private LocalDateTime modified;
        @Nullable
        private String name;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckoutActions.CheckoutResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.gid(instance.getGid());
            this.repo(instance.getRepo());
            this.commit(instance.getCommit());
            this.modified(instance.getModified());
            this.name(instance.getName());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gid(String gid) {
            this.gid = Objects.requireNonNull(gid, "gid");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(String repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modified(LocalDateTime modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableCheckoutResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, this.modified, this.name, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("gid");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modified");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build CheckoutResult, some of required attributes are not set " + attributes;
        }
    }
}

