/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Diff;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff", generator="Immutables")
@Immutable
public final class ImmutableDiff
implements Diff {
    private final Repo repo;
    private final ImmutableList<Diff.Divergence> divergences;

    private ImmutableDiff(Repo repo, ImmutableList<Diff.Divergence> divergences) {
        this.repo = repo;
        this.divergences = divergences;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    public ImmutableList<Diff.Divergence> getDivergences() {
        return this.divergences;
    }

    public final ImmutableDiff withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableDiff(newValue, this.divergences);
    }

    public final ImmutableDiff withDivergences(Diff.Divergence ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDiff(this.repo, (ImmutableList<Diff.Divergence>)newValue);
    }

    public final ImmutableDiff withDivergences(Iterable<? extends Diff.Divergence> elements) {
        if (this.divergences == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDiff(this.repo, (ImmutableList<Diff.Divergence>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiff && this.equalTo((ImmutableDiff)another);
    }

    private boolean equalTo(ImmutableDiff another) {
        return this.repo.equals(another.repo) && this.divergences.equals(another.divergences);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.divergences.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Diff").omitNullValues().add("repo", (Object)this.repo).add("divergences", this.divergences).toString();
    }

    public static ImmutableDiff copyOf(Diff instance) {
        if (instance instanceof ImmutableDiff) {
            return (ImmutableDiff)instance;
        }
        return ImmutableDiff.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private long initBits = 1L;
        @Nullable
        private Repo repo;
        private ImmutableList.Builder<Diff.Divergence> divergences = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.addAllDivergences(instance.getDivergences());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDivergences(Diff.Divergence element) {
            this.divergences.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDivergences(Diff.Divergence ... elements) {
            this.divergences.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder divergences(Iterable<? extends Diff.Divergence> elements) {
            this.divergences = ImmutableList.builder();
            return this.addAllDivergences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDivergences(Iterable<? extends Diff.Divergence> elements) {
            this.divergences.addAll(elements);
            return this;
        }

        public ImmutableDiff build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiff(this.repo, (ImmutableList<Diff.Divergence>)this.divergences.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            return "Cannot build Diff, some of required attributes are not set " + attributes;
        }
    }
}

