/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Diff;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff.DiffAction", generator="Immutables")
@Immutable
public final class ImmutableDiffAction
implements Diff.DiffAction {
    private final Diff.DiffActionType type;
    @Nullable
    private final Diff.DiffBlob value;
    @Nullable
    private final Diff.DiffBlob target;

    private ImmutableDiffAction(Diff.DiffActionType type, @Nullable Diff.DiffBlob value, @Nullable Diff.DiffBlob target) {
        this.type = type;
        this.value = value;
        this.target = target;
    }

    @Override
    public Diff.DiffActionType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Diff.DiffBlob getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Diff.DiffBlob getTarget() {
        return this.target;
    }

    public final ImmutableDiffAction withType(Diff.DiffActionType value) {
        if (this.type == value) {
            return this;
        }
        Diff.DiffActionType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDiffAction(newValue, this.value, this.target);
    }

    public final ImmutableDiffAction withValue(@Nullable Diff.DiffBlob value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableDiffAction(this.type, value, this.target);
    }

    public final ImmutableDiffAction withTarget(@Nullable Diff.DiffBlob value) {
        if (this.target == value) {
            return this;
        }
        return new ImmutableDiffAction(this.type, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffAction && this.equalTo((ImmutableDiffAction)another);
    }

    private boolean equalTo(ImmutableDiffAction another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.value, another.value) && Objects.equals(this.target, another.target);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.target);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffAction").omitNullValues().add("type", (Object)this.type).add("value", (Object)this.value).add("target", (Object)this.target).toString();
    }

    public static ImmutableDiffAction copyOf(Diff.DiffAction instance) {
        if (instance instanceof ImmutableDiffAction) {
            return (ImmutableDiffAction)instance;
        }
        return ImmutableDiffAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff.DiffAction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Diff.DiffActionType type;
        @Nullable
        private Diff.DiffBlob value;
        @Nullable
        private Diff.DiffBlob target;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff.DiffAction instance) {
            Diff.DiffBlob targetValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            Diff.DiffBlob valueValue = instance.getValue();
            if (valueValue != null) {
                this.value(valueValue);
            }
            if ((targetValue = instance.getTarget()) != null) {
                this.target(targetValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Diff.DiffActionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable Diff.DiffBlob value) {
            this.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder target(@Nullable Diff.DiffBlob target) {
            this.target = target;
            return this;
        }

        public ImmutableDiffAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffAction(this.type, this.value, this.target);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build DiffAction, some of required attributes are not set " + attributes;
        }
    }
}

