/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Diff;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff.DivergenceRef", generator="Immutables")
@Immutable
public final class ImmutableDivergenceRef
implements Diff.DivergenceRef {
    private final ImmutableList<String> refs;
    private final ImmutableList<String> tags;
    private final Integer commits;
    private final Objects.Commit commit;

    private ImmutableDivergenceRef(ImmutableList<String> refs, ImmutableList<String> tags, Integer commits, Objects.Commit commit) {
        this.refs = refs;
        this.tags = tags;
        this.commits = commits;
        this.commit = commit;
    }

    public ImmutableList<String> getRefs() {
        return this.refs;
    }

    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    public Integer getCommits() {
        return this.commits;
    }

    @Override
    public Objects.Commit getCommit() {
        return this.commit;
    }

    public final ImmutableDivergenceRef withRefs(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDivergenceRef((ImmutableList<String>)newValue, this.tags, this.commits, this.commit);
    }

    public final ImmutableDivergenceRef withRefs(Iterable<String> elements) {
        if (this.refs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDivergenceRef((ImmutableList<String>)newValue, this.tags, this.commits, this.commit);
    }

    public final ImmutableDivergenceRef withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDivergenceRef(this.refs, (ImmutableList<String>)newValue, this.commits, this.commit);
    }

    public final ImmutableDivergenceRef withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDivergenceRef(this.refs, (ImmutableList<String>)newValue, this.commits, this.commit);
    }

    public final ImmutableDivergenceRef withCommits(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "commits");
        if (this.commits.equals(newValue)) {
            return this;
        }
        return new ImmutableDivergenceRef(this.refs, this.tags, newValue, this.commit);
    }

    public final ImmutableDivergenceRef withCommit(Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        Objects.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableDivergenceRef(this.refs, this.tags, this.commits, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDivergenceRef && this.equalTo((ImmutableDivergenceRef)another);
    }

    private boolean equalTo(ImmutableDivergenceRef another) {
        return this.refs.equals(another.refs) && this.tags.equals(another.tags) && this.commits.equals(another.commits) && this.commit.equals(another.commit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.refs.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.commits.hashCode();
        h += (h << 5) + this.commit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DivergenceRef").omitNullValues().add("refs", this.refs).add("tags", this.tags).add("commits", (Object)this.commits).add("commit", (Object)this.commit).toString();
    }

    public static ImmutableDivergenceRef copyOf(Diff.DivergenceRef instance) {
        if (instance instanceof ImmutableDivergenceRef) {
            return (ImmutableDivergenceRef)instance;
        }
        return ImmutableDivergenceRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff.DivergenceRef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMITS = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<String> refs = ImmutableList.builder();
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        @Nullable
        private Integer commits;
        @Nullable
        private Objects.Commit commit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff.DivergenceRef instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllRefs(instance.getRefs());
            this.addAllTags(instance.getTags());
            this.commits(instance.getCommits());
            this.commit(instance.getCommit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRefs(String element) {
            this.refs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRefs(String ... elements) {
            this.refs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refs(Iterable<String> elements) {
            this.refs = ImmutableList.builder();
            return this.addAllRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRefs(Iterable<String> elements) {
            this.refs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commits(Integer commits) {
            this.commits = Objects.requireNonNull(commits, "commits");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Objects.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDivergenceRef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDivergenceRef((ImmutableList<String>)this.refs.build(), (ImmutableList<String>)this.tags.build(), this.commits, this.commit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commits");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            return "Cannot build DivergenceRef, some of required attributes are not set " + attributes;
        }
    }
}

