/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects", generator="Immutables")
@Immutable
public final class ImmutableObjects
implements Objects {
    private final ImmutableMap<String, Objects.Ref> refs;
    private final ImmutableMap<String, Objects.Tag> tags;
    private final ImmutableMap<String, Objects.IsObject> values;

    private ImmutableObjects(ImmutableMap<String, Objects.Ref> refs, ImmutableMap<String, Objects.Tag> tags, ImmutableMap<String, Objects.IsObject> values) {
        this.refs = refs;
        this.tags = tags;
        this.values = values;
    }

    public ImmutableMap<String, Objects.Ref> getRefs() {
        return this.refs;
    }

    public ImmutableMap<String, Objects.Tag> getTags() {
        return this.tags;
    }

    public ImmutableMap<String, Objects.IsObject> getValues() {
        return this.values;
    }

    public final ImmutableObjects withRefs(Map<String, ? extends Objects.Ref> entries) {
        if (this.refs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableObjects((ImmutableMap<String, Objects.Ref>)newValue, this.tags, this.values);
    }

    public final ImmutableObjects withTags(Map<String, ? extends Objects.Tag> entries) {
        if (this.tags == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableObjects(this.refs, (ImmutableMap<String, Objects.Tag>)newValue, this.values);
    }

    public final ImmutableObjects withValues(Map<String, ? extends Objects.IsObject> entries) {
        if (this.values == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableObjects(this.refs, this.tags, (ImmutableMap<String, Objects.IsObject>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableObjects && this.equalTo((ImmutableObjects)another);
    }

    private boolean equalTo(ImmutableObjects another) {
        return this.refs.equals(another.refs) && this.tags.equals(another.tags) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.refs.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Objects").omitNullValues().add("refs", this.refs).add("tags", this.tags).add("values", this.values).toString();
    }

    public static ImmutableObjects copyOf(Objects instance) {
        if (instance instanceof ImmutableObjects) {
            return (ImmutableObjects)instance;
        }
        return ImmutableObjects.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, Objects.Ref> refs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Objects.Tag> tags = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Objects.IsObject> values = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects instance) {
            java.util.Objects.requireNonNull(instance, "instance");
            this.putAllRefs(instance.getRefs());
            this.putAllTags(instance.getTags());
            this.putAllValues(instance.getValues());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRefs(String key, Objects.Ref value) {
            this.refs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRefs(Map.Entry<String, ? extends Objects.Ref> entry) {
            this.refs.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refs(Map<String, ? extends Objects.Ref> entries) {
            this.refs = ImmutableMap.builder();
            return this.putAllRefs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRefs(Map<String, ? extends Objects.Ref> entries) {
            this.refs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(String key, Objects.Tag value) {
            this.tags.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(Map.Entry<String, ? extends Objects.Tag> entry) {
            this.tags.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(Map<String, ? extends Objects.Tag> entries) {
            this.tags = ImmutableMap.builder();
            return this.putAllTags(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTags(Map<String, ? extends Objects.Tag> entries) {
            this.tags.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValues(String key, Objects.IsObject value) {
            this.values.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValues(Map.Entry<String, ? extends Objects.IsObject> entry) {
            this.values.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(Map<String, ? extends Objects.IsObject> entries) {
            this.values = ImmutableMap.builder();
            return this.putAllValues(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllValues(Map<String, ? extends Objects.IsObject> entries) {
            this.values.putAll(entries);
            return this;
        }

        public ImmutableObjects build() {
            return new ImmutableObjects((ImmutableMap<String, Objects.Ref>)this.refs.build(), (ImmutableMap<String, Objects.Tag>)this.tags.build(), (ImmutableMap<String, Objects.IsObject>)this.values.build());
        }
    }
}

