/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Repo.RepoHeadState", generator="Immutables")
@Immutable
public final class ImmutableRepoHeadState
implements Repo.RepoHeadState {
    private final String gid;
    private final String repoId;
    private final String headName;
    private final String commit;
    private final Repo.HeadStateKind kind;

    private ImmutableRepoHeadState(String gid, String repoId, String headName, String commit, Repo.HeadStateKind kind) {
        this.gid = gid;
        this.repoId = repoId;
        this.headName = headName;
        this.commit = commit;
        this.kind = kind;
    }

    @Override
    public String getGid() {
        return this.gid;
    }

    @Override
    public String getRepoId() {
        return this.repoId;
    }

    @Override
    public String getHeadName() {
        return this.headName;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public Repo.HeadStateKind getKind() {
        return this.kind;
    }

    public final ImmutableRepoHeadState withGid(String value) {
        String newValue = Objects.requireNonNull(value, "gid");
        if (this.gid.equals(newValue)) {
            return this;
        }
        return new ImmutableRepoHeadState(newValue, this.repoId, this.headName, this.commit, this.kind);
    }

    public final ImmutableRepoHeadState withRepoId(String value) {
        String newValue = Objects.requireNonNull(value, "repoId");
        if (this.repoId.equals(newValue)) {
            return this;
        }
        return new ImmutableRepoHeadState(this.gid, newValue, this.headName, this.commit, this.kind);
    }

    public final ImmutableRepoHeadState withHeadName(String value) {
        String newValue = Objects.requireNonNull(value, "headName");
        if (this.headName.equals(newValue)) {
            return this;
        }
        return new ImmutableRepoHeadState(this.gid, this.repoId, newValue, this.commit, this.kind);
    }

    public final ImmutableRepoHeadState withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableRepoHeadState(this.gid, this.repoId, this.headName, newValue, this.kind);
    }

    public final ImmutableRepoHeadState withKind(Repo.HeadStateKind value) {
        if (this.kind == value) {
            return this;
        }
        Repo.HeadStateKind newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRepoHeadState(this.gid, this.repoId, this.headName, this.commit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepoHeadState && this.equalTo((ImmutableRepoHeadState)another);
    }

    private boolean equalTo(ImmutableRepoHeadState another) {
        return this.gid.equals(another.gid) && this.repoId.equals(another.repoId) && this.headName.equals(another.headName) && this.commit.equals(another.commit) && this.kind.equals((Object)another.kind);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.gid.hashCode();
        h += (h << 5) + this.repoId.hashCode();
        h += (h << 5) + this.headName.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.kind.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepoHeadState").omitNullValues().add("gid", (Object)this.gid).add("repoId", (Object)this.repoId).add("headName", (Object)this.headName).add("commit", (Object)this.commit).add("kind", (Object)this.kind).toString();
    }

    public static ImmutableRepoHeadState copyOf(Repo.RepoHeadState instance) {
        if (instance instanceof ImmutableRepoHeadState) {
            return (ImmutableRepoHeadState)instance;
        }
        return ImmutableRepoHeadState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Repo.RepoHeadState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GID = 1L;
        private static final long INIT_BIT_REPO_ID = 2L;
        private static final long INIT_BIT_HEAD_NAME = 4L;
        private static final long INIT_BIT_COMMIT = 8L;
        private static final long INIT_BIT_KIND = 16L;
        private long initBits = 31L;
        @Nullable
        private String gid;
        @Nullable
        private String repoId;
        @Nullable
        private String headName;
        @Nullable
        private String commit;
        @Nullable
        private Repo.HeadStateKind kind;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Repo.RepoHeadState instance) {
            Objects.requireNonNull(instance, "instance");
            this.gid(instance.getGid());
            this.repoId(instance.getRepoId());
            this.headName(instance.getHeadName());
            this.commit(instance.getCommit());
            this.kind(instance.getKind());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gid(String gid) {
            this.gid = Objects.requireNonNull(gid, "gid");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoId(String repoId) {
            this.repoId = Objects.requireNonNull(repoId, "repoId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headName(String headName) {
            this.headName = Objects.requireNonNull(headName, "headName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kind(Repo.HeadStateKind kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRepoHeadState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepoHeadState(this.gid, this.repoId, this.headName, this.commit, this.kind);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("gid");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repoId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("headName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("kind");
            }
            return "Cannot build RepoHeadState, some of required attributes are not set " + attributes;
        }
    }
}

