/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects.Tag", generator="Immutables")
@Immutable
public final class ImmutableTag
implements Objects.Tag {
    private final String name;
    private final String commit;
    private final LocalDateTime dateTime;
    private final String author;
    private final String message;

    private ImmutableTag(String name, String commit, LocalDateTime dateTime, String author, String message) {
        this.name = name;
        this.commit = commit;
        this.dateTime = dateTime;
        this.author = author;
        this.message = message;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public final ImmutableTag withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(newValue, this.commit, this.dateTime, this.author, this.message);
    }

    public final ImmutableTag withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(this.name, newValue, this.dateTime, this.author, this.message);
    }

    public final ImmutableTag withDateTime(LocalDateTime value) {
        if (this.dateTime == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "dateTime");
        return new ImmutableTag(this.name, this.commit, newValue, this.author, this.message);
    }

    public final ImmutableTag withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(this.name, this.commit, this.dateTime, newValue, this.message);
    }

    public final ImmutableTag withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableTag(this.name, this.commit, this.dateTime, this.author, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTag && this.equalTo((ImmutableTag)another);
    }

    private boolean equalTo(ImmutableTag another) {
        return this.name.equals(another.name) && this.commit.equals(another.commit) && this.dateTime.equals(another.dateTime) && this.author.equals(another.author) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.dateTime.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Tag").omitNullValues().add("name", (Object)this.name).add("commit", (Object)this.commit).add("dateTime", (Object)this.dateTime).add("author", (Object)this.author).add("message", (Object)this.message).toString();
    }

    public static ImmutableTag copyOf(Objects.Tag instance) {
        if (instance instanceof ImmutableTag) {
            return (ImmutableTag)instance;
        }
        return ImmutableTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects.Tag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private static final long INIT_BIT_DATE_TIME = 4L;
        private static final long INIT_BIT_AUTHOR = 8L;
        private static final long INIT_BIT_MESSAGE = 16L;
        private long initBits = 31L;
        @Nullable
        private String name;
        @Nullable
        private String commit;
        @Nullable
        private LocalDateTime dateTime;
        @Nullable
        private String author;
        @Nullable
        private String message;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.IsName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.Tag instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Objects.IsName instance;
            if (object instanceof Objects.IsName) {
                instance = (Objects.IsName)object;
                this.name(instance.getName());
            }
            if (object instanceof Objects.Tag) {
                instance = (Objects.Tag)object;
                this.dateTime(instance.getDateTime());
                this.commit(instance.getCommit());
                this.message(instance.getMessage());
                this.author(instance.getAuthor());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dateTime(LocalDateTime dateTime) {
            this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTag build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTag(this.name, this.commit, this.dateTime, this.author, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dateTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build Tag, some of required attributes are not set " + attributes;
        }
    }
}

