/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file;

import io.resys.thena.docdb.api.models.ImmutableBlob;
import io.resys.thena.docdb.api.models.ImmutableCommit;
import io.resys.thena.docdb.api.models.ImmutableRef;
import io.resys.thena.docdb.api.models.ImmutableRepo;
import io.resys.thena.docdb.api.models.ImmutableTag;
import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.ImmutableTreeValue;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.file.tables.BlobTable;
import io.resys.thena.docdb.file.tables.CommitTable;
import io.resys.thena.docdb.file.tables.RefTable;
import io.resys.thena.docdb.file.tables.RepoTable;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.file.tables.TagTable;
import io.resys.thena.docdb.file.tables.TreeItemTable;
import io.resys.thena.docdb.file.tables.TreeTable;
import java.time.LocalDateTime;
import java.util.Optional;

public class DefaultFileMapper
implements Table.FileMapper {
    @Override
    public Repo repo(Table.Row src) {
        RepoTable.RepoTableRow row = src.toType(RepoTable.RepoTableRow.class);
        return ImmutableRepo.builder().id(row.getId()).rev(row.getRev()).name(row.getName()).prefix(row.getPrefix()).build();
    }

    @Override
    public Objects.Commit commit(Table.Row src) {
        CommitTable.CommitTableRow row = src.toType(CommitTable.CommitTableRow.class);
        return ImmutableCommit.builder().id(row.getId()).author(row.getAuthor()).dateTime(LocalDateTime.parse(row.getDatetime())).message(row.getMessage()).parent(Optional.ofNullable(row.getParent())).merge(Optional.ofNullable(row.getMerge())).tree(row.getTree()).build();
    }

    @Override
    public Objects.Tree tree(Table.Row src) {
        TreeTable.TreeTableRow row = src.toType(TreeTable.TreeTableRow.class);
        return ImmutableTree.builder().id(row.getId()).build();
    }

    @Override
    public Objects.TreeValue treeItem(Table.Row src) {
        TreeItemTable.TreeItemTableRow row = src.toType(TreeItemTable.TreeItemTableRow.class);
        return ImmutableTreeValue.builder().name(row.getName()).blob(row.getBlob()).build();
    }

    @Override
    public Objects.Tag tag(Table.Row src) {
        TagTable.TagTableRow row = src.toType(TagTable.TagTableRow.class);
        return ImmutableTag.builder().author(row.getAuthor()).dateTime(LocalDateTime.parse(row.getDatetime())).message(row.getMessage()).commit(row.getCommit()).name(row.getId()).build();
    }

    @Override
    public Objects.Ref ref(Table.Row src) {
        RefTable.RefTableRow row = src.toType(RefTable.RefTableRow.class);
        return ImmutableRef.builder().name(row.getName()).commit(row.getCommit()).build();
    }

    @Override
    public Objects.Blob blob(Table.Row src) {
        BlobTable.BlobTableRow row = src.toType(BlobTable.BlobTableRow.class);
        return ImmutableBlob.builder().id(row.getId()).value(row.getValue()).build();
    }
}

