/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file;

import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.file.ClientQueryFilePool;
import io.resys.thena.docdb.file.DefaultFileBuilder;
import io.resys.thena.docdb.file.DefaultFileMapper;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.builders.ClientInsertBuilderFilePool;
import io.resys.thena.docdb.file.builders.RepoBuilderFilePool;
import io.resys.thena.docdb.file.tables.ImmutableFileClientWrapper;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.DocDBDefault;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;

public class DocDBFactoryFile {
    public static Builder create() {
        return new Builder();
    }

    public static ClientState state(final ClientCollections ctx, final Table.FilePool client, final ErrorHandler handler) {
        return new ClientState(){

            @Override
            public ErrorHandler getErrorHandler() {
                return handler;
            }

            @Override
            public ClientCollections getCollections() {
                return ctx;
            }

            @Override
            public ClientState.RepoBuilder repos() {
                return new RepoBuilderFilePool(client, ctx, DocDBFactoryFile.sqlMapper(ctx), DocDBFactoryFile.sqlBuilder(ctx), handler);
            }

            @Override
            public Uni<ClientInsertBuilder> insert(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.insert((Repo)repo));
            }

            @Override
            public ClientInsertBuilder insert(Repo repo) {
                ImmutableFileClientWrapper wrapper = ImmutableFileClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientInsertBuilderFilePool(wrapper.getClient(), DocDBFactoryFile.sqlMapper(wrapper.getNames()), DocDBFactoryFile.sqlBuilder(wrapper.getNames()), handler);
            }

            @Override
            public Uni<ClientQuery> query(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.query((Repo)repo));
            }

            @Override
            public ClientQuery query(Repo repo) {
                ImmutableFileClientWrapper wrapper = ImmutableFileClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientQueryFilePool(wrapper, DocDBFactoryFile.sqlMapper(wrapper.getNames()), DocDBFactoryFile.sqlBuilder(wrapper.getNames()), handler);
            }

            @Override
            public ClientState.ClientRepoState withRepo(Repo repo) {
                final ImmutableFileClientWrapper wrapper = ImmutableFileClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientState.ClientRepoState(){

                    @Override
                    public ClientQuery query() {
                        return new ClientQueryFilePool(wrapper, DocDBFactoryFile.sqlMapper(wrapper.getNames()), DocDBFactoryFile.sqlBuilder(wrapper.getNames()), handler);
                    }

                    @Override
                    public ClientInsertBuilder insert() {
                        return new ClientInsertBuilderFilePool(wrapper.getClient(), DocDBFactoryFile.sqlMapper(wrapper.getNames()), DocDBFactoryFile.sqlBuilder(wrapper.getNames()), handler);
                    }
                };
            }

            @Override
            public Uni<ClientState.ClientRepoState> withRepo(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.withRepo((Repo)repo));
            }
        };
    }

    public static FileBuilder sqlBuilder(ClientCollections ctx) {
        return new DefaultFileBuilder(ctx);
    }

    public static Table.FileMapper sqlMapper(ClientCollections ctx) {
        return new DefaultFileMapper();
    }

    public static class Builder {
        private Table.FilePool client;
        private String db = "docdb";
        private ErrorHandler errorHandler;

        public Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder client(Table.FilePool client) {
            this.client = client;
            return this;
        }

        public DocDB build() {
            RepoAssert.notNull(this.client, () -> "client must be defined!");
            RepoAssert.notNull(this.db, () -> "db must be defined!");
            RepoAssert.notNull(this.errorHandler, () -> "errorHandler must be defined!");
            ClientCollections ctx = ClientCollections.defaults(this.db);
            return new DocDBDefault(DocDBFactoryFile.state(ctx, this.client, this.errorHandler));
        }
    }
}

