/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlobQueryFilePool
implements ClientQuery.BlobQuery {
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder builder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Blob> id(String blobId) {
        Table.FileTuple sql = this.builder.blobs().getById(blobId);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.blob(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Blob)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by 'id': '" + blobId + "'!", (Throwable)e));
    }

    @Override
    public Uni<List<Objects.Blob>> id(List<String> blobId) {
        Table.FileTuple sql = this.builder.blobs().findByIds(blobId);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.blob(row)).execute().onItem().transform(rowset -> {
            ArrayList<Objects.Blob> result = new ArrayList<Objects.Blob>();
            for (Objects.Blob item : rowset) {
                result.add(item);
            }
            return result;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by 'id'-s: '" + String.join((CharSequence)",", blobId) + "'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Blob> find() {
        Table.FileStatement sql = this.builder.blobs().findAll();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.blob(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Blob> find(Objects.Tree tree) {
        Table.FileTuple sql = this.builder.blobs().findByTree(tree);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.blob(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by tree: " + tree.getId() + "!", (Throwable)e));
    }

    public BlobQueryFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder builder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.builder = builder;
        this.errorHandler = errorHandler;
    }
}

