/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.ImmutableInsertResult;
import io.resys.thena.docdb.spi.ImmutableUpsertResult;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import io.resys.thena.docdb.spi.commits.ImmutableCommitOutput;
import io.smallrye.mutiny.Uni;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInsertBuilderFilePool
implements ClientInsertBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClientInsertBuilderFilePool.class);
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<ClientInsertBuilder.InsertResult> tag(Objects.Tag tag) {
        Table.FileTuple tagInsert = this.sqlBuilder.tags().insertOne(tag);
        return this.client.preparedQuery(tagInsert).execute().onItem().transform(inserted -> ImmutableInsertResult.builder().duplicate(false).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableInsertResult.builder().duplicate(true).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'TAG': '" + tagInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> blob(Objects.Blob blob) {
        Table.FileTuple blobsInsert = this.sqlBuilder.blobs().insertOne(blob);
        return this.client.preparedQuery(blobsInsert).execute().onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(true).target(blob).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(false).target(blob).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'BLOB': '" + blobsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> ref(Objects.Ref ref, Objects.Commit commit) {
        Table.FileTuple findByName = this.sqlBuilder.refs().getByName(ref.getName());
        return this.client.preparedQuery(findByName).mapping(r -> this.mapper.ref(r)).execute().onItem().transformToUni(item -> {
            Iterator exists = item.iterator();
            if (!exists.hasNext()) {
                return this.createRef(ref, commit);
            }
            return this.updateRef((Objects.Ref)exists.next(), commit);
        });
    }

    public Uni<ClientInsertBuilder.UpsertResult> updateRef(Objects.Ref ref, Objects.Commit commit) {
        Table.FileTuple refInsert = this.sqlBuilder.refs().updateOne(ref, commit);
        return this.client.preparedQuery(refInsert).execute().onItem().transform(updateResult -> {
            if (updateResult.size() == 1) {
                return ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).status(ClientInsertBuilder.UpsertStatus.OK).target(ref).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been updated.").build()).build();
            }
            return ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).status(ClientInsertBuilder.UpsertStatus.CONFLICT).target(ref).message(ImmutableMessage.builder().text("Ref with" + " id: '" + ref.getName() + "'," + " commit: '" + ref.getCommit() + "'" + " is behind of the head.").build()).build();
        });
    }

    private Uni<ClientInsertBuilder.UpsertResult> createRef(Objects.Ref ref, Objects.Commit commit) {
        Table.FileTuple refsInsert = this.sqlBuilder.refs().insertOne(ref);
        return this.client.preparedQuery(refsInsert).execute().onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).target(ref).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been created.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).target(ref).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " is already created.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'REF': '" + refsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> tree(Objects.Tree tree) {
        Table.FileTuple treeInsert = this.sqlBuilder.trees().insertOne(tree);
        Table.FileTupleList treeValueInsert = this.sqlBuilder.treeItems().insertAll(tree);
        return this.client.preparedQuery(treeInsert).execute().onItem().transformToUni(junk -> this.client.preparedQuery(treeValueInsert).execute()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(true).target(tree).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(false).target(tree).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into \r\n'TREE': " + treeInsert.getValue() + "\r\n  and/or\r\n 'TREE_VALUE' : '" + treeValueInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> commit(Objects.Commit commit) {
        Table.FileTuple commitsInsert = this.sqlBuilder.commits().insertOne(commit);
        return this.client.preparedQuery(commitsInsert).execute().onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(true).target(commit).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(false).target(commit).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message(ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'COMMIT': '" + commitsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<CommitVisitor.CommitOutput> output(CommitVisitor.CommitOutput output) {
        Table.FileTupleList blobsInsert = this.sqlBuilder.blobs().insertAll(output.getBlobs());
        Table.FileTuple treeInsert = this.sqlBuilder.trees().insertOne(output.getTree());
        Table.FileTupleList treeValueInsert = this.sqlBuilder.treeItems().insertAll(output.getTree());
        Table.FileTuple commitsInsert = this.sqlBuilder.commits().insertOne(output.getCommit());
        Table.FileTuple findRefByName = this.sqlBuilder.refs().getByName(output.getRef().getName());
        Uni start = blobsInsert.getProps().isEmpty() ? Uni.createFrom().item((Object)this.successOutput(output, "No new blobs provided, nothing to save")) : ClientInsertBuilderFilePool.apply(this.client, blobsInsert).onItem().transform(row -> this.successOutput(output, "Blobs saved, number of new entries: " + row.size())).onFailure().recoverWithItem(e -> this.failOutput(output, "Failed to create blobs", (Throwable)e));
        return start.chain(next -> {
            if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                return ClientInsertBuilderFilePool.apply(this.client, treeInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Tree saved, number of new entries: " + row.size())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create tree \r\n" + output.getTree(), (Throwable)e));
            }
            return Uni.createFrom().item(next);
        }).chain(next -> {
            if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                if (treeValueInsert.getProps().isEmpty()) {
                    return Uni.createFrom().item((Object)this.successOutput((CommitVisitor.CommitOutput)next, "Tree Values saved, number of new entries: 0"));
                }
                return ClientInsertBuilderFilePool.apply(this.client, treeValueInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Tree Values saved, number of new entries: " + row.size())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create tree values", (Throwable)e));
            }
            return Uni.createFrom().item(next);
        }).chain(next -> {
            if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                return ClientInsertBuilderFilePool.apply(this.client, commitsInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Commit saved, number of new entries: " + row.size())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create commit", (Throwable)e));
            }
            return Uni.createFrom().item(next);
        }).chain(next -> {
            if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                return ClientInsertBuilderFilePool.apply(this.client, findRefByName).onItem().transformToUni(item -> {
                    Iterator exists = item.iterator();
                    if (!exists.hasNext()) {
                        return ClientInsertBuilderFilePool.apply(this.client, this.sqlBuilder.refs().insertOne(next.getRef())).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "New ref created: " + next.getRef().getName() + ": " + next.getRef().getCommit()));
                    }
                    return ClientInsertBuilderFilePool.apply(this.client, this.sqlBuilder.refs().updateOne(next.getRef(), next.getCommit())).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Existing ref: " + next.getRef().getName() + ", updated with commit: " + next.getRef().getCommit()));
                }).onFailure().recoverWithItem(e -> this.failOutput(output, "Failed to create/update ref", (Throwable)e));
            }
            return Uni.createFrom().item(next);
        });
    }

    private CommitVisitor.CommitOutput successOutput(CommitVisitor.CommitOutput current, String msg) {
        return ImmutableCommitOutput.builder().from(current).status(CommitVisitor.CommitOutputStatus.OK).addMessages((Message)ImmutableMessage.builder().text(msg).build()).build();
    }

    private CommitVisitor.CommitOutput failOutput(CommitVisitor.CommitOutput current, String msg, Throwable t) {
        return ImmutableCommitOutput.builder().from(current).status(CommitVisitor.CommitOutputStatus.ERROR).addMessages((Message)ImmutableMessage.builder().text(msg).build()).build();
    }

    public static Uni<List<Object>> apply(Table.FilePool client, Table.FileTupleList sql) {
        return client.preparedQuery(sql).execute().onFailure().invoke(e -> log.error(System.lineSeparator() + "Failed to execute command." + System.lineSeparator() + "  sql: " + sql.getValue() + System.lineSeparator() + "  error:" + e.getMessage(), e));
    }

    public static Uni<List<Object>> apply(Table.FilePool client, Table.FileTuple sql) {
        return client.preparedQuery(sql).execute().onFailure().invoke(e -> log.error(System.lineSeparator() + "Failed to execute command." + System.lineSeparator() + "  sql: " + sql.getValue() + System.lineSeparator() + "  error:" + e.getMessage(), e));
    }

    public ClientInsertBuilderFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

