/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniJoin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RepoBuilderFilePool
implements ClientState.RepoBuilder {
    private final Table.FilePool client;
    private final ClientCollections names;
    private final Table.FileMapper mapper;
    private final FileBuilder builder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Repo> getByName(String name) {
        Table.FileTuple sql = this.builder.repo().getByName(name);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.repo(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Repo)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS' by 'name'!", (Throwable)e));
    }

    @Override
    public Uni<Repo> getByNameOrId(String nameOrId) {
        Table.FileTuple sql = this.builder.repo().getByNameOrId(nameOrId);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.repo(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Repo)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS' by 'name' or 'id'!", (Throwable)e));
    }

    @Override
    public Uni<Repo> insert(Repo newRepo) {
        ClientCollections next = this.names.toRepo(newRepo);
        FileBuilder sqlBuilder = this.builder.withOptions(next);
        Table.FileTuple repoInsert = sqlBuilder.repo().insertOne(newRepo);
        List<Table.FileStatement> tablesCreate = Arrays.asList(sqlBuilder.blobs().create(), sqlBuilder.commits().create(), sqlBuilder.treeItems().create(), sqlBuilder.trees().create(), sqlBuilder.refs().create(), sqlBuilder.tags().create(), sqlBuilder.commits().constraints(), sqlBuilder.refs().constraints(), sqlBuilder.tags().constraints(), sqlBuilder.treeItems().constraints());
        Uni create = this.client.preparedQuery(sqlBuilder.repo().create()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create table 'REPOS'!", (Throwable)e));
        Uni insert = this.client.preparedQuery(repoInsert).execute().onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'REPO': '" + repoInsert.getValue() + "'!", (Throwable)e));
        ArrayList<Uni> commands = new ArrayList<Uni>();
        commands.add(create);
        commands.add(insert);
        for (Table.FileStatement table : tablesCreate) {
            Table.FilePreparedQuery<Object> query = null;
            query = table instanceof Table.FileStatement ? this.client.preparedQuery(table) : (table instanceof Table.FileTuple ? this.client.preparedQuery((Table.FileTuple)((Object)table)) : this.client.preparedQuery((Table.FileTupleList)((Object)table)));
            Uni nested = query.execute().onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create tables: " + tablesCreate, (Throwable)e));
            commands.add(nested);
        }
        UniJoin.JoinAllStrategy join = Uni.join().all(commands.toArray(new Uni[0]));
        return join.andFailFast().onItem().transform(items -> newRepo);
    }

    @Override
    public Multi<Repo> find() {
        return this.client.preparedQuery(this.builder.repo().findAll()).mapping(row -> this.mapper.repo(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithCompletion().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS'!", (Throwable)e));
    }

    @Override
    public Uni<Void> create() {
        return this.client.preparedQuery(this.builder.repo().create()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create table 'REPOS'!", (Throwable)e));
    }

    public RepoBuilderFilePool(Table.FilePool client, ClientCollections names, Table.FileMapper mapper, FileBuilder builder, ErrorHandler errorHandler) {
        this.client = client;
        this.names = names;
        this.mapper = mapper;
        this.builder = builder;
        this.errorHandler = errorHandler;
    }
}

