/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.ImmutableDeleteResult;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Iterator;

public class TagQueryFilePool
implements ClientQuery.TagQuery {
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder sqlBuilder;
    private final ErrorHandler errorHandler;
    private String name;

    @Override
    public ClientQuery.TagQuery name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Uni<ClientQuery.DeleteResult> delete() {
        Table.FileTuple sql = this.sqlBuilder.tags().deleteByName(this.name);
        return this.client.preparedQuery(sql).execute().onItem().transform(result -> ImmutableDeleteResult.builder().deletedCount(1L).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't delete 'TAG' by name: '" + this.name + "'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Tag> get() {
        Table.FileStatement sql = this.sqlBuilder.tags().getFirst();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.tag(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Tag)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Tag> find() {
        if (this.name == null || this.name.isBlank()) {
            Table.FileStatement sql = this.sqlBuilder.tags().findAll();
            return this.client.preparedQuery(sql).mapping(row -> this.mapper.tag(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG'!", (Throwable)e));
        }
        Table.FileTuple sql = this.sqlBuilder.tags().getByName(this.name);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.tag(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG' by name: '" + this.name + "'!", (Throwable)e));
    }

    public TagQueryFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

