/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public class TreeQueryFilePool
implements ClientQuery.TreeQuery {
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Tree> id(String tree) {
        Table.FileTuple sql = this.sqlBuilder.treeItems().getByTreeId(tree);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.treeItem(row)).execute().onItem().transform(rowset -> {
            ImmutableTree.Builder builder = ImmutableTree.builder().id(tree);
            for (Objects.TreeValue item : rowset) {
                builder.putValues(item.getName(), item);
            }
            return builder.build();
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find/load 'TREE': " + tree + "!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Tree> find() {
        Table.FileStatement sql = this.sqlBuilder.trees().findAll();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.tree(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onItem().transformToUni(tree -> this.id(tree.getId())).concatenate().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TREE'!", (Throwable)e));
    }

    public TreeQueryFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

