/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.thena.docdb.file.spi.RepoTableImpl;
import io.resys.thena.docdb.file.tables.RepoTable;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConnection
implements Table.Connection {
    private static final Logger log = LoggerFactory.getLogger(FileConnection.class);
    private final File rootDir;
    private final ObjectMapper objectMapper;
    private final Map<String, RepoTable> cache = new HashMap<String, RepoTable>();

    public FileConnection(File rootDir, ObjectMapper objectMapper) {
        this.rootDir = rootDir;
        this.objectMapper = objectMapper;
    }

    @Override
    public RepoTable getRepoTable(ClientCollections ctx) {
        if (this.cache.containsKey(ctx.getDb())) {
            return this.cache.get(ctx.getDb());
        }
        File db = new File(this.rootDir, ctx.getDb());
        log.info("Started local file pool in directory: " + db.getAbsolutePath());
        if (!db.exists()) {
            db.mkdir();
        }
        RepoTableImpl repo = new RepoTableImpl(db, ctx, this.objectMapper);
        this.cache.put(ctx.getDb(), repo);
        return repo;
    }

    public static abstract class FileTable<T extends Table.Row> {
        private static final Logger log = LoggerFactory.getLogger(FileTable.class);
        private final Class<T> type;
        private final File db;
        private final File asset;
        private final ObjectMapper objectMapper;
        private final String assetName;
        private final TypeReference<List<T>> ref;
        private boolean cache_created;
        private List<T> cache_rows;

        public FileTable(File db, String asset, ObjectMapper objectMapper, Class<T> type, TypeReference<List<T>> ref) {
            this.ref = ref;
            this.db = db;
            this.type = type;
            this.assetName = asset;
            this.asset = new File(db, asset);
            this.cache_created = this.asset.exists();
            this.objectMapper = objectMapper;
            log.info("Started local table: " + asset + ", in: " + this.asset.getAbsolutePath());
        }

        public String getTableName() {
            return this.assetName;
        }

        public T update(T oldState, T newState) {
            String criteria = this.writeJson(oldState);
            Optional<Table.Row> oldRow = this.getRows().stream().filter(s -> this.writeJson(s).equals(criteria)).findFirst();
            if (oldRow.isEmpty()) {
                throw new IllegalArgumentException("can't find old state: " + criteria);
            }
            try {
                ArrayList<T> nextState = new ArrayList<T>(this.getRows());
                nextState.remove(oldRow.get());
                nextState.add(newState);
                this.write(this.objectMapper.writeValueAsString(nextState));
                this.cache_rows = nextState;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return newState;
        }

        public T delete(T entry) {
            String criteria = this.writeJson(entry);
            Optional<Table.Row> old = this.getRows().stream().filter(s -> this.writeJson(s).equals(criteria)).findFirst();
            if (old.isEmpty()) {
                throw new IllegalArgumentException("can't find old state: " + criteria);
            }
            try {
                ArrayList<T> nextState = new ArrayList<T>(this.getRows());
                nextState.remove(old.get());
                this.write(this.objectMapper.writeValueAsString(nextState));
                this.cache_rows = nextState;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return entry;
        }

        public List<T> getRows() {
            if (this.cache_rows == null) {
                this.cache_rows = this.read(this.type);
            }
            return Collections.unmodifiableList(this.cache_rows);
        }

        public boolean create() {
            try {
                if (this.cache_created) {
                    boolean isEmpty = this.read().trim().isEmpty();
                    if (isEmpty) {
                        this.write(this.objectMapper.writeValueAsString(new ArrayList()));
                    }
                    return false;
                }
                this.write(this.objectMapper.writeValueAsString(new ArrayList()));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return true;
        }

        public Boolean getExists() {
            return this.asset.exists();
        }

        public List<T> insertAll(List<T> entry) {
            try {
                ArrayList<T> next = new ArrayList<T>(this.getRows());
                next.addAll(entry);
                this.write(this.objectMapper.writeValueAsString(next));
                this.cache_rows = next;
                return entry;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public T insert(T type) {
            try {
                ArrayList<T> next = new ArrayList<T>(this.getRows());
                next.add(type);
                this.write(this.objectMapper.writeValueAsString(next));
                this.cache_rows = next;
                return type;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private List<T> read(Class<T> type) {
            if (!this.asset.exists()) {
                return Collections.emptyList();
            }
            try {
                String jsonString = this.read();
                return (List)this.objectMapper.readValue(jsonString, this.ref);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected String writeJson(T type) {
            try {
                return this.objectMapper.writeValueAsString(type);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private String read() {
            FileInputStream out = null;
            try {
                out = new FileInputStream(this.asset);
                String string = new String(out.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }

        private String write(String content) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.asset);
                out.write(content.getBytes(StandardCharsets.UTF_8));
                String string = content;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
    }
}

