/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.thena.docdb.file.spi.FileConnection;
import io.resys.thena.docdb.file.tables.Table;
import io.smallrye.mutiny.Uni;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTuplePreparedQuery<T>
implements Table.FilePreparedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(FileTuplePreparedQuery.class);
    private final File rootDir;
    private final Table.FileCommand query;
    private final Function<Table.Row, T> mapper;
    private final ObjectMapper objectMapper;
    private final FileConnection conn;

    @Override
    public <U> Table.FilePreparedQuery<U> mapping(Function<Table.Row, U> mapper) {
        return new FileTuplePreparedQuery<U>(this.rootDir, this.query, mapper, this.objectMapper, this.conn);
    }

    @Override
    public Uni<List<T>> execute() {
        return Uni.createFrom().item(() -> {
            log.info(this.query.getValue());
            List<? extends Table.Row> rows = this.query.getCommand().apply(this.conn);
            List mapped = rows.stream().map(r -> {
                if (this.mapper == null) {
                    return r;
                }
                return this.mapper.apply((Table.Row)r);
            }).collect(Collectors.toList());
            return mapped;
        });
    }

    public FileTuplePreparedQuery(File rootDir, Table.FileCommand query, Function<Table.Row, T> mapper, ObjectMapper objectMapper, FileConnection conn) {
        this.rootDir = rootDir;
        this.query = query;
        this.mapper = mapper;
        this.objectMapper = objectMapper;
        this.conn = conn;
    }
}

