/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableRefTableRow;
import io.resys.thena.docdb.file.tables.RefTable;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RefFileBuilderImpl
implements FileBuilder.RefFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create REF table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getRefs().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement constraints() {
        return ImmutableFileStatement.builder().value("Apply constraints on table REF").command(conn -> Arrays.asList(new Table.Row(){})).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from REF table").command(root -> root.getRepoTable(this.ctx).getRefs().getRows()).build();
    }

    @Override
    public Table.FileTuple getByName(String name) {
        return ImmutableFileTuple.builder().value("Select by name from REF table").command(root -> root.getRepoTable(this.ctx).getRefs().getRows().stream().filter(r -> r.getName().equals(name)).collect(Collectors.toList())).props(Tuple.of((Object)name)).build();
    }

    @Override
    public Table.FileTuple getByNameOrCommit(String refNameOrCommit) {
        return ImmutableFileTuple.builder().value("Select by name from REF table").command(root -> root.getRepoTable(this.ctx).getRefs().getRows().stream().filter(r -> r.getName().equals(refNameOrCommit) || r.getCommit().equals(refNameOrCommit)).collect(Collectors.toList())).props(Tuple.of((Object)refNameOrCommit)).build();
    }

    @Override
    public Table.FileStatement getFirst() {
        return ImmutableFileStatement.builder().value("Select first from REF table").command(root -> {
            List refs = root.getRepoTable(this.ctx).getRefs().getRows();
            if (refs.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList((RefTable.RefTableRow)refs.get(0));
        }).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Ref ref) {
        return ImmutableFileTuple.builder().value("Insert new row into REF table").command(root -> {
            Optional<RefTable.RefTableRow> exists = root.getRepoTable(this.ctx).getRefs().getRows().stream().filter(r -> r.getName().equals(ref.getName())).findFirst();
            if (!exists.isEmpty()) {
                throw new IllegalArgumentException("REF already exists with name: " + ref.getName());
            }
            ImmutableRefTableRow newRow = ImmutableRefTableRow.builder().name(ref.getName()).commit(ref.getCommit()).build();
            root.getRepoTable(this.ctx).getRefs().insert(newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.of((Object)ref.getName(), (Object)ref.getCommit())).build();
    }

    @Override
    public Table.FileTuple updateOne(Objects.Ref ref, Objects.Commit commit) {
        return ImmutableFileTuple.builder().value("Update row in REF table").command(root -> {
            Optional<RefTable.RefTableRow> exists = root.getRepoTable(this.ctx).getRefs().getRows().stream().filter(r -> r.getName().equals(ref.getName()) && r.getCommit().equals(commit.getParent().get())).findFirst();
            if (exists.isEmpty()) {
                throw new IllegalArgumentException("REF does not exists with commit: " + ref.getCommit());
            }
            ImmutableRefTableRow newRow = ImmutableRefTableRow.builder().name(ref.getName()).commit(ref.getCommit()).build();
            root.getRepoTable(this.ctx).getRefs().update(exists.get(), newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.of((Object)ref.getCommit(), (Object)ref.getName(), (Object)commit.getParent().get())).build();
    }

    public RefFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

