/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableRepoTableRow;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RepoFileBuilderImpl
implements FileBuilder.RepoFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileTuple exists() {
        return ImmutableFileTuple.builder().value("Does REPO table exist").command(conn -> Arrays.asList(new Table.RowExists((Table.Connection)conn){
            final /* synthetic */ Table.Connection val$conn;
            {
                this.val$conn = connection;
            }

            @Override
            public boolean getExists() {
                return this.val$conn.getRepoTable(RepoFileBuilderImpl.this.ctx).getExists();
            }
        })).props(Tuple.of((Object)"repo")).build();
    }

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create REPO table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("select all from REPO table").command(root -> new ArrayList(root.getRepoTable(this.ctx).getRows())).build();
    }

    @Override
    public Table.FileTuple getByName(String name) {
        return ImmutableFileTuple.builder().value("select from REPO table by name").command(root -> root.getRepoTable(this.ctx).getRows().stream().filter(r -> r.getName().equals(name)).collect(Collectors.toList())).props(Tuple.of((Object)name)).build();
    }

    @Override
    public Table.FileTuple getByNameOrId(String name) {
        return ImmutableFileTuple.builder().value("select from REPO table by name or id").command(root -> root.getRepoTable(this.ctx).getRows().stream().filter(r -> r.getName().equals(name) || r.getId().equals(name)).collect(Collectors.toList())).props(Tuple.of((Object)name)).build();
    }

    @Override
    public Table.FileTuple insertOne(Repo newRepo) {
        return ImmutableFileTuple.builder().value("Insert new row into REPO table").command(root -> Arrays.asList(root.getRepoTable(this.ctx).insert(ImmutableRepoTableRow.builder().id(newRepo.getId()).rev(newRepo.getRev()).prefix(newRepo.getPrefix()).name(newRepo.getName()).build()))).props(Tuple.of((Object)newRepo.getId(), (Object)newRepo.getRev(), (Object)newRepo.getPrefix(), (Object)newRepo.getName())).build();
    }

    public RepoFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

