/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.thena.docdb.file.spi.FileConnection;
import io.resys.thena.docdb.file.tables.BlobTable;
import io.resys.thena.docdb.file.tables.CommitTable;
import io.resys.thena.docdb.file.tables.RefTable;
import io.resys.thena.docdb.file.tables.RepoTable;
import io.resys.thena.docdb.file.tables.TagTable;
import io.resys.thena.docdb.file.tables.TreeItemTable;
import io.resys.thena.docdb.file.tables.TreeTable;
import io.resys.thena.docdb.spi.ClientCollections;
import java.io.File;
import java.util.List;

public class RepoTableImpl
extends FileConnection.FileTable<RepoTable.RepoTableRow>
implements RepoTable {
    private final ClientCollections ctx;
    private final BlobTable blobs;
    private final CommitTable commits;
    private final RefTable refs;
    private final TagTable tags;
    private final TreeItemTable treeItems;
    private final TreeTable trees;

    public RepoTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
        super(db, ctx.getRepos(), objectMapper, RepoTable.RepoTableRow.class, new TypeReference<List<RepoTable.RepoTableRow>>(){});
        this.ctx = ctx;
        this.blobs = new BlobTableImpl(db, ctx, objectMapper);
        this.commits = new CommitTableImpl(db, ctx, objectMapper);
        this.refs = new RefTableImpl(db, ctx, objectMapper);
        this.tags = new TagTableImpl(db, ctx, objectMapper);
        this.treeItems = new TreeItemTableImpl(db, ctx, objectMapper);
        this.trees = new TreeTableImpl(db, ctx, objectMapper);
    }

    @Override
    public BlobTable getBlobs() {
        return this.blobs;
    }

    @Override
    public CommitTable getCommits() {
        return this.commits;
    }

    @Override
    public RefTable getRefs() {
        return this.refs;
    }

    @Override
    public TagTable getTags() {
        return this.tags;
    }

    @Override
    public TreeItemTable getTreeItems() {
        return this.treeItems;
    }

    @Override
    public TreeTable getTrees() {
        return this.trees;
    }

    public static class BlobTableImpl
    extends FileConnection.FileTable<BlobTable.BlobTableRow>
    implements BlobTable {
        public BlobTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getBlobs(), objectMapper, BlobTable.BlobTableRow.class, new TypeReference<List<BlobTable.BlobTableRow>>(){});
        }
    }

    public static class CommitTableImpl
    extends FileConnection.FileTable<CommitTable.CommitTableRow>
    implements CommitTable {
        public CommitTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getCommits(), objectMapper, CommitTable.CommitTableRow.class, new TypeReference<List<CommitTable.CommitTableRow>>(){});
        }
    }

    public static class TagTableImpl
    extends FileConnection.FileTable<TagTable.TagTableRow>
    implements TagTable {
        public TagTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getTags(), objectMapper, TagTable.TagTableRow.class, new TypeReference<List<TagTable.TagTableRow>>(){});
        }
    }

    public static class TreeItemTableImpl
    extends FileConnection.FileTable<TreeItemTable.TreeItemTableRow>
    implements TreeItemTable {
        public TreeItemTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getTreeItems(), objectMapper, TreeItemTable.TreeItemTableRow.class, new TypeReference<List<TreeItemTable.TreeItemTableRow>>(){});
        }
    }

    public static class TreeTableImpl
    extends FileConnection.FileTable<TreeTable.TreeTableRow>
    implements TreeTable {
        public TreeTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getTrees(), objectMapper, TreeTable.TreeTableRow.class, new TypeReference<List<TreeTable.TreeTableRow>>(){});
        }

        @Override
        public List<TreeTable.TreeTableRow> insertAll(List<TreeTable.TreeTableRow> entry) {
            return super.insertAll(entry);
        }

        @Override
        public TreeTable.TreeTableRow insert(TreeTable.TreeTableRow type) {
            return super.insert(type);
        }
    }

    public static class RefTableImpl
    extends FileConnection.FileTable<RefTable.RefTableRow>
    implements RefTable {
        public RefTableImpl(File db, ClientCollections ctx, ObjectMapper objectMapper) {
            super(db, ctx.getRefs(), objectMapper, RefTable.RefTableRow.class, new TypeReference<List<RefTable.RefTableRow>>(){});
        }
    }
}

