/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableTreeTableRow;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.file.tables.TreeTable;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TreeFileBuilderImpl
implements FileBuilder.TreeFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create TREE table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getTrees().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from TREE table").command(root -> root.getRepoTable(this.ctx).getTrees().getRows()).build();
    }

    @Override
    public Table.FileTuple getById(String id) {
        return ImmutableFileTuple.builder().value("Select by id from TREE table").props(Tuple.of((Object)id)).command(root -> root.getRepoTable(this.ctx).getTrees().getRows().stream().filter(tree -> tree.getId().equals(id)).collect(Collectors.toList())).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Tree src) {
        return ImmutableFileTuple.builder().value("Insert row into TREE table").props(Tuple.of((Object)src.getId())).command(root -> {
            List exists = root.getRepoTable(this.ctx).getTrees().getRows().stream().filter(tree -> tree.getId().equals(src.getId())).collect(Collectors.toList());
            if (!exists.isEmpty()) {
                return exists;
            }
            TreeTable.TreeTableRow newRow = root.getRepoTable(this.ctx).getTrees().insert(ImmutableTreeTableRow.builder().id(src.getId()).build());
            return Arrays.asList(newRow);
        }).build();
    }

    public TreeFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

