/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableFileTupleList;
import io.resys.thena.docdb.file.tables.ImmutableTreeItemTableRow;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.file.tables.TreeItemTable;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class TreeItemFileBuilderImpl
implements FileBuilder.TreeItemFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create TREE_ITEM table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getTreeItems().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement constraints() {
        return ImmutableFileStatement.builder().value("Apply constraints on table TREE_ITEM").command(conn -> Arrays.asList(new Table.Row(){})).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from TREE_ITEM table").command(root -> root.getRepoTable(this.ctx).getTreeItems().getRows()).build();
    }

    @Override
    public Table.FileTuple getByTreeId(String treeId) {
        return ImmutableFileTuple.builder().value("Select by tree from TREE_ITEM table").command(root -> root.getRepoTable(this.ctx).getTreeItems().getRows().stream().filter(r -> r.getTree().equals(treeId)).collect(Collectors.toList())).props(Tuple.of((Object)treeId)).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Tree tree, Objects.TreeValue item) {
        return ImmutableFileTuple.builder().value("Insert new row into TREE_ITEM table").command(root -> {
            Optional<TreeItemTable.TreeItemTableRow> exists = root.getRepoTable(this.ctx).getTreeItems().getRows().stream().filter(r -> r.getName().equals(item.getName()) && r.getBlob().equals(item.getBlob()) && r.getTree().equals(tree.getId())).findFirst();
            if (!exists.isEmpty()) {
                return Arrays.asList(exists.get());
            }
            ImmutableTreeItemTableRow newRow = ImmutableTreeItemTableRow.builder().id(UUID.randomUUID().toString()).name(item.getName()).blob(item.getBlob()).tree(tree.getId()).build();
            root.getRepoTable(this.ctx).getTreeItems().insert(newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.of((Object)item.getName(), (Object)item.getBlob(), (Object)tree.getId())).build();
    }

    @Override
    public Table.FileTupleList insertAll(Objects.Tree tree) {
        return ImmutableFileTupleList.builder().value("Insert new rows into TREE_ITEM table").props(tree.getValues().values().stream().map(v -> Tuple.of((Object)v.getName(), (Object)v.getBlob(), (Object)tree.getId())).collect(Collectors.toList())).command(root -> {
            Map<String, TreeItemTable.TreeItemTableRow> byId = root.getRepoTable(this.ctx).getTreeItems().getRows().stream().collect(Collectors.toMap(e -> e.getName() + e.getBlob() + e.getTree(), e -> e));
            ArrayList inserts = new ArrayList();
            ArrayList results = new ArrayList();
            tree.getValues().values().stream().forEach(treeItem -> {
                String key = treeItem.getName() + treeItem.getBlob() + tree.getId();
                if (byId.containsKey(key)) {
                    results.add((TreeItemTable.TreeItemTableRow)byId.get(key));
                } else {
                    ImmutableTreeItemTableRow newRow = ImmutableTreeItemTableRow.builder().id(UUID.randomUUID().toString()).name(treeItem.getName()).blob(treeItem.getBlob()).tree(tree.getId()).build();
                    inserts.add(newRow);
                    results.add(newRow);
                }
            });
            root.getRepoTable(this.ctx).getTreeItems().insertAll(inserts);
            return results;
        }).build();
    }

    public TreeItemFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

