/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Table.FileClientWrapper", generator="Immutables")
@Immutable
public final class ImmutableFileClientWrapper
implements Table.FileClientWrapper {
    private final Repo repo;
    private final Table.FilePool client;
    private final ClientCollections names;

    private ImmutableFileClientWrapper(Repo repo, Table.FilePool client, ClientCollections names) {
        this.repo = repo;
        this.client = client;
        this.names = names;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Table.FilePool getClient() {
        return this.client;
    }

    @Override
    public ClientCollections getNames() {
        return this.names;
    }

    public final ImmutableFileClientWrapper withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableFileClientWrapper(newValue, this.client, this.names);
    }

    public final ImmutableFileClientWrapper withClient(Table.FilePool value) {
        if (this.client == value) {
            return this;
        }
        Table.FilePool newValue = Objects.requireNonNull(value, "client");
        return new ImmutableFileClientWrapper(this.repo, newValue, this.names);
    }

    public final ImmutableFileClientWrapper withNames(ClientCollections value) {
        if (this.names == value) {
            return this;
        }
        ClientCollections newValue = Objects.requireNonNull(value, "names");
        return new ImmutableFileClientWrapper(this.repo, this.client, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileClientWrapper && this.equalTo((ImmutableFileClientWrapper)another);
    }

    private boolean equalTo(ImmutableFileClientWrapper another) {
        return this.repo.equals(another.repo) && this.client.equals(another.client) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileClientWrapper").omitNullValues().add("repo", (Object)this.repo).add("client", (Object)this.client).add("names", (Object)this.names).toString();
    }

    public static ImmutableFileClientWrapper copyOf(Table.FileClientWrapper instance) {
        if (instance instanceof ImmutableFileClientWrapper) {
            return (ImmutableFileClientWrapper)instance;
        }
        return ImmutableFileClientWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Table.FileClientWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private static final long INIT_BIT_NAMES = 4L;
        private long initBits = 7L;
        @Nullable
        private Repo repo;
        @Nullable
        private Table.FilePool client;
        @Nullable
        private ClientCollections names;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileClientWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.client(instance.getClient());
            this.names(instance.getNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(Table.FilePool client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder names(ClientCollections names) {
            this.names = Objects.requireNonNull(names, "names");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFileClientWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileClientWrapper(this.repo, this.client, this.names);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("names");
            }
            return "Cannot build FileClientWrapper, some of required attributes are not set " + attributes;
        }
    }
}

