/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.Table;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Table.FileTupleList", generator="Immutables")
@Immutable
public final class ImmutableFileTupleList
implements Table.FileTupleList {
    private final String value;
    private final Function<Table.Connection, List<? extends Table.Row>> command;
    private final ImmutableList<Tuple> props;

    private ImmutableFileTupleList(String value, Function<Table.Connection, List<? extends Table.Row>> command, ImmutableList<Tuple> props) {
        this.value = value;
        this.command = command;
        this.props = props;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
        return this.command;
    }

    public ImmutableList<Tuple> getProps() {
        return this.props;
    }

    public final ImmutableFileTupleList withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableFileTupleList(newValue, this.command, this.props);
    }

    public final ImmutableFileTupleList withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
        if (this.command == value) {
            return this;
        }
        Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
        return new ImmutableFileTupleList(this.value, newValue, this.props);
    }

    public final ImmutableFileTupleList withProps(Tuple ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFileTupleList(this.value, this.command, (ImmutableList<Tuple>)newValue);
    }

    public final ImmutableFileTupleList withProps(Iterable<? extends Tuple> elements) {
        if (this.props == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFileTupleList(this.value, this.command, (ImmutableList<Tuple>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileTupleList && this.equalTo((ImmutableFileTupleList)another);
    }

    private boolean equalTo(ImmutableFileTupleList another) {
        return this.value.equals(another.value) && this.command.equals(another.command) && this.props.equals(another.props);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.props.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileTupleList").omitNullValues().add("value", (Object)this.value).add("command", this.command).add("props", this.props).toString();
    }

    public static ImmutableFileTupleList copyOf(Table.FileTupleList instance) {
        if (instance instanceof ImmutableFileTupleList) {
            return (ImmutableFileTupleList)instance;
        }
        return ImmutableFileTupleList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Table.FileTupleList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private Function<Table.Connection, List<? extends Table.Row>> command;
        private ImmutableList.Builder<Tuple> props = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileTupleList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Table.FileCommand instance;
            if (object instanceof Table.FileCommand) {
                instance = (Table.FileCommand)object;
                this.value(instance.getValue());
                this.command(instance.getCommand());
            }
            if (object instanceof Table.FileTupleList) {
                instance = (Table.FileTupleList)object;
                this.addAllProps(instance.getProps());
            }
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProps(Tuple element) {
            this.props.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProps(Tuple ... elements) {
            this.props.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder props(Iterable<? extends Tuple> elements) {
            this.props = ImmutableList.builder();
            return this.addAllProps(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProps(Iterable<? extends Tuple> elements) {
            this.props.addAll(elements);
            return this;
        }

        public ImmutableFileTupleList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileTupleList(this.value, this.command, (ImmutableList<Tuple>)this.props.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build FileTupleList, some of required attributes are not set " + attributes;
        }
    }
}

