/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.TreeItemTable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TreeItemTable.TreeItemTableRow", generator="Immutables")
@Immutable
public final class ImmutableTreeItemTableRow
implements TreeItemTable.TreeItemTableRow {
    private final String id;
    private final String name;
    private final String blob;
    private final String tree;

    private ImmutableTreeItemTableRow(String id, String name, String blob, String tree) {
        this.id = id;
        this.name = name;
        this.blob = blob;
        this.tree = tree;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="blob")
    public String getBlob() {
        return this.blob;
    }

    @Override
    @JsonProperty(value="tree")
    public String getTree() {
        return this.tree;
    }

    public final ImmutableTreeItemTableRow withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeItemTableRow(newValue, this.name, this.blob, this.tree);
    }

    public final ImmutableTreeItemTableRow withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeItemTableRow(this.id, newValue, this.blob, this.tree);
    }

    public final ImmutableTreeItemTableRow withBlob(String value) {
        String newValue = Objects.requireNonNull(value, "blob");
        if (this.blob.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeItemTableRow(this.id, this.name, newValue, this.tree);
    }

    public final ImmutableTreeItemTableRow withTree(String value) {
        String newValue = Objects.requireNonNull(value, "tree");
        if (this.tree.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeItemTableRow(this.id, this.name, this.blob, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTreeItemTableRow && this.equalTo((ImmutableTreeItemTableRow)another);
    }

    private boolean equalTo(ImmutableTreeItemTableRow another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.blob.equals(another.blob) && this.tree.equals(another.tree);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.blob.hashCode();
        h += (h << 5) + this.tree.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TreeItemTableRow").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("blob", (Object)this.blob).add("tree", (Object)this.tree).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTreeItemTableRow fromJson(Json json) {
        Builder builder = ImmutableTreeItemTableRow.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.blob != null) {
            builder.blob(json.blob);
        }
        if (json.tree != null) {
            builder.tree(json.tree);
        }
        return builder.build();
    }

    public static ImmutableTreeItemTableRow copyOf(TreeItemTable.TreeItemTableRow instance) {
        if (instance instanceof ImmutableTreeItemTableRow) {
            return (ImmutableTreeItemTableRow)instance;
        }
        return ImmutableTreeItemTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TreeItemTable.TreeItemTableRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_BLOB = 4L;
        private static final long INIT_BIT_TREE = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String blob;
        @Nullable
        private String tree;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TreeItemTable.TreeItemTableRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.blob(instance.getBlob());
            this.tree(instance.getTree());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="blob")
        @CanIgnoreReturnValue
        public final Builder blob(String blob) {
            this.blob = Objects.requireNonNull(blob, "blob");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="tree")
        @CanIgnoreReturnValue
        public final Builder tree(String tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTreeItemTableRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTreeItemTableRow(this.id, this.name, this.blob, this.tree);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("blob");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build TreeItemTableRow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TreeItemTable.TreeItemTableRow", generator="Immutables")
    static final class Json
    implements TreeItemTable.TreeItemTableRow {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String blob;
        @Nullable
        String tree;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="blob")
        public void setBlob(String blob) {
            this.blob = blob;
        }

        @JsonProperty(value="tree")
        public void setTree(String tree) {
            this.tree = tree;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTree() {
            throw new UnsupportedOperationException();
        }
    }
}

