/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.TreeTable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TreeTable.TreeTableRow", generator="Immutables")
@Immutable
public final class ImmutableTreeTableRow
implements TreeTable.TreeTableRow {
    private final String id;

    private ImmutableTreeTableRow(String id) {
        this.id = id;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public final ImmutableTreeTableRow withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeTableRow(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTreeTableRow && this.equalTo((ImmutableTreeTableRow)another);
    }

    private boolean equalTo(ImmutableTreeTableRow another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TreeTableRow").omitNullValues().add("id", (Object)this.id).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTreeTableRow fromJson(Json json) {
        Builder builder = ImmutableTreeTableRow.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableTreeTableRow copyOf(TreeTable.TreeTableRow instance) {
        if (instance instanceof ImmutableTreeTableRow) {
            return (ImmutableTreeTableRow)instance;
        }
        return ImmutableTreeTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TreeTable.TreeTableRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TreeTable.TreeTableRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTreeTableRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTreeTableRow(this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build TreeTableRow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TreeTable.TreeTableRow", generator="Immutables")
    static final class Json
    implements TreeTable.TreeTableRow {
        @Nullable
        String id;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }
    }
}

