/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.actions.CheckoutActions;
import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.DiffActions;
import io.resys.thena.docdb.api.actions.HistoryActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.resys.thena.docdb.api.actions.TagActions;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.checkout.CheckoutActionsDefault;
import io.resys.thena.docdb.spi.commits.CommitActionsDefault;
import io.resys.thena.docdb.spi.diff.DiffActionsDefault;
import io.resys.thena.docdb.spi.history.HistoryActionsDefault;
import io.resys.thena.docdb.spi.objects.ObjectsActionsDefault;
import io.resys.thena.docdb.spi.repo.RepoActionsDefault;
import io.resys.thena.docdb.spi.tags.TagActionsDefault;

public class DocDBDefault
implements DocDB {
    private final ClientState state;
    private RepoActions repoActions;
    private CommitActions commitActions;
    private TagActions tagActions;
    private CheckoutActions checkoutActions;
    private HistoryActions historyActions;
    private ObjectsActions objectsActions;
    private DiffActions diffActions;

    public DocDBDefault(ClientState state) {
        this.state = state;
    }

    @Override
    public RepoActions repo() {
        if (this.repoActions == null) {
            this.repoActions = new RepoActionsDefault(this.state);
        }
        return this.repoActions;
    }

    @Override
    public CommitActions commit() {
        if (this.commitActions == null) {
            this.commitActions = new CommitActionsDefault(this.state, this.objects());
        }
        return this.commitActions;
    }

    @Override
    public TagActions tag() {
        if (this.tagActions == null) {
            this.tagActions = new TagActionsDefault(this.state);
        }
        return this.tagActions;
    }

    @Override
    public CheckoutActions checkout() {
        if (this.checkoutActions == null) {
            this.checkoutActions = new CheckoutActionsDefault(this.state);
        }
        return this.checkoutActions;
    }

    @Override
    public HistoryActions history() {
        if (this.historyActions == null) {
            this.historyActions = new HistoryActionsDefault(this.state);
        }
        return this.historyActions;
    }

    @Override
    public ObjectsActions objects() {
        if (this.objectsActions == null) {
            this.objectsActions = new ObjectsActionsDefault(this.state);
        }
        return this.objectsActions;
    }

    @Override
    public DiffActions diff() {
        if (this.diffActions == null) {
            this.diffActions = new DiffActionsDefault(this.state, this.objects());
        }
        return this.diffActions;
    }
}

