/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.spi.ClientCollections;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientCollections", generator="Immutables")
@Immutable
public final class ImmutableClientCollections
extends ClientCollections {
    private final String db;
    private final String repos;
    private final String refs;
    private final String tags;
    private final String blobs;
    private final String trees;
    private final String treeItems;
    private final String commits;

    private ImmutableClientCollections(String db, String repos, String refs, String tags, String blobs, String trees, String treeItems, String commits) {
        this.db = db;
        this.repos = repos;
        this.refs = refs;
        this.tags = tags;
        this.blobs = blobs;
        this.trees = trees;
        this.treeItems = treeItems;
        this.commits = commits;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getRepos() {
        return this.repos;
    }

    @Override
    public String getRefs() {
        return this.refs;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public String getBlobs() {
        return this.blobs;
    }

    @Override
    public String getTrees() {
        return this.trees;
    }

    @Override
    public String getTreeItems() {
        return this.treeItems;
    }

    @Override
    public String getCommits() {
        return this.commits;
    }

    public final ImmutableClientCollections withDb(String value) {
        String newValue = Objects.requireNonNull(value, "db");
        if (this.db.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(newValue, this.repos, this.refs, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withRepos(String value) {
        String newValue = Objects.requireNonNull(value, "repos");
        if (this.repos.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, newValue, this.refs, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withRefs(String value) {
        String newValue = Objects.requireNonNull(value, "refs");
        if (this.refs.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, newValue, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withTags(String value) {
        String newValue = Objects.requireNonNull(value, "tags");
        if (this.tags.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, this.refs, newValue, this.blobs, this.trees, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withBlobs(String value) {
        String newValue = Objects.requireNonNull(value, "blobs");
        if (this.blobs.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, newValue, this.trees, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withTrees(String value) {
        String newValue = Objects.requireNonNull(value, "trees");
        if (this.trees.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, newValue, this.treeItems, this.commits);
    }

    public final ImmutableClientCollections withTreeItems(String value) {
        String newValue = Objects.requireNonNull(value, "treeItems");
        if (this.treeItems.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, this.trees, newValue, this.commits);
    }

    public final ImmutableClientCollections withCommits(String value) {
        String newValue = Objects.requireNonNull(value, "commits");
        if (this.commits.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, this.trees, this.treeItems, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCollections && this.equalTo((ImmutableClientCollections)another);
    }

    private boolean equalTo(ImmutableClientCollections another) {
        return this.db.equals(another.db) && this.repos.equals(another.repos) && this.refs.equals(another.refs) && this.tags.equals(another.tags) && this.blobs.equals(another.blobs) && this.trees.equals(another.trees) && this.treeItems.equals(another.treeItems) && this.commits.equals(another.commits);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.repos.hashCode();
        h += (h << 5) + this.refs.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        h += (h << 5) + this.trees.hashCode();
        h += (h << 5) + this.treeItems.hashCode();
        h += (h << 5) + this.commits.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClientCollections").omitNullValues().add("db", (Object)this.db).add("repos", (Object)this.repos).add("refs", (Object)this.refs).add("tags", (Object)this.tags).add("blobs", (Object)this.blobs).add("trees", (Object)this.trees).add("treeItems", (Object)this.treeItems).add("commits", (Object)this.commits).toString();
    }

    public static ImmutableClientCollections copyOf(ClientCollections instance) {
        if (instance instanceof ImmutableClientCollections) {
            return (ImmutableClientCollections)instance;
        }
        return ImmutableClientCollections.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientCollections", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_REPOS = 2L;
        private static final long INIT_BIT_REFS = 4L;
        private static final long INIT_BIT_TAGS = 8L;
        private static final long INIT_BIT_BLOBS = 16L;
        private static final long INIT_BIT_TREES = 32L;
        private static final long INIT_BIT_TREE_ITEMS = 64L;
        private static final long INIT_BIT_COMMITS = 128L;
        private long initBits = 255L;
        @Nullable
        private String db;
        @Nullable
        private String repos;
        @Nullable
        private String refs;
        @Nullable
        private String tags;
        @Nullable
        private String blobs;
        @Nullable
        private String trees;
        @Nullable
        private String treeItems;
        @Nullable
        private String commits;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientCollections instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.getDb());
            this.repos(instance.getRepos());
            this.refs(instance.getRefs());
            this.tags(instance.getTags());
            this.blobs(instance.getBlobs());
            this.trees(instance.getTrees());
            this.treeItems(instance.getTreeItems());
            this.commits(instance.getCommits());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(String db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repos(String repos) {
            this.repos = Objects.requireNonNull(repos, "repos");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refs(String refs) {
            this.refs = Objects.requireNonNull(refs, "refs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(String tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobs(String blobs) {
            this.blobs = Objects.requireNonNull(blobs, "blobs");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trees(String trees) {
            this.trees = Objects.requireNonNull(trees, "trees");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeItems(String treeItems) {
            this.treeItems = Objects.requireNonNull(treeItems, "treeItems");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commits(String commits) {
            this.commits = Objects.requireNonNull(commits, "commits");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableClientCollections build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("refs");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("tags");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("blobs");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("trees");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("treeItems");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("commits");
            }
            return "Cannot build ClientCollections, some of required attributes are not set " + attributes;
        }
    }
}

