/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import io.resys.thena.docdb.spi.commits.ImmutableCommitOutput;
import io.smallrye.mutiny.Uni;

public class CommitSaveVisitor {
    private final ClientState.ClientRepoState state;

    public CommitSaveVisitor(ClientState.ClientRepoState state) {
        this.state = state;
    }

    public Uni<CommitVisitor.CommitOutput> visit(CommitVisitor.CommitOutput output) {
        return this.state.query().refs().nameOrCommit(output.getRef().getName()).onItem().transformToUni(item -> {
            if (item == null && output.getCommit().getParent().isEmpty()) {
                return this.state.insert().output(output);
            }
            if (item != null && output.getCommit().getParent().isPresent() && item.getCommit().equals(output.getCommit().getParent().get())) {
                return this.state.insert().output(output);
            }
            StringBuilder error = new StringBuilder();
            if (item == null && output.getCommit().getParent().isPresent()) {
                error.append("Commit points to unknown head: ").append("'").append(output.getRef().getName()).append("@").append(output.getCommit().getParent()).append("'!");
            } else if (item != null && !item.getCommit().equals(output.getCommit().getParent().get())) {
                error.append("Commit is behind of the head: ").append("'").append(item.getName()).append("@").append(item.getCommit()).append("'!");
            }
            return Uni.createFrom().item((Object)ImmutableCommitOutput.builder().from(output).status(CommitVisitor.CommitOutputStatus.CONFLICT).addMessages((Message)ImmutableMessage.builder().text(error.toString()).build()).build());
        });
    }
}

