/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.ImmutableBlob;
import io.resys.thena.docdb.api.models.ImmutableCommit;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.ImmutableRef;
import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.ImmutableTreeValue;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.commits.ImmutableCommitOutput;
import io.resys.thena.docdb.spi.commits.ImmutableRedundentHashedBlob;
import io.resys.thena.docdb.spi.commits.Sha2;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class CommitVisitor {
    private final Map<String, Objects.Blob> nextBlobs = new HashMap<String, Objects.Blob>();
    private final Map<String, Objects.TreeValue> nextTree = new HashMap<String, Objects.TreeValue>();
    private final StringBuilder logger = new StringBuilder();
    private boolean dataDeleted = false;
    private boolean dataAdded = false;

    public CommitOutput visit(CommitInput input) {
        if (input.getParent().isPresent()) {
            this.visitParent(input.getParent().get());
        }
        this.visitAppend(input.getAppend());
        this.visitRemove(input.getRemove());
        Objects.Tree tree = this.visitTree();
        Collection<Objects.Blob> blobs = this.visitBlobs();
        Objects.Commit commit = this.visitCommit(tree, input);
        return ImmutableCommitOutput.builder().log(this.visitLog()).repo(input.getRepo()).ref(this.visitRef(commit, input)).status(this.visitEmpty()).tree(tree).blobs(blobs).commit(commit).build();
    }

    private Objects.Ref visitRef(Objects.Commit commit, CommitInput input) {
        return ImmutableRef.builder().commit(commit.getId()).name(input.getRef()).build();
    }

    private Objects.Commit visitCommit(Objects.Tree tree, CommitInput input) {
        Optional<String> parent = input.getParent().map(r -> r.getCommit().getId());
        ImmutableCommit commitTemplate = ImmutableCommit.builder().id("commit-template").author(input.getCommitAuthor()).message(input.getCommitMessage()).dateTime(LocalDateTime.now()).parent(parent).tree(tree.getId()).build();
        ImmutableCommit commit = ImmutableCommit.builder().from(commitTemplate).id(Sha2.commitId(commitTemplate)).build();
        return commit;
    }

    private Collection<Objects.Blob> visitBlobs() {
        Collection<Objects.Blob> blobs = this.nextBlobs.values();
        return blobs;
    }

    private Objects.Tree visitTree() {
        ImmutableTree tree = ImmutableTree.builder().id(Sha2.treeId(this.nextTree)).values(this.nextTree).build();
        return tree;
    }

    private CommitOutputStatus visitEmpty() {
        boolean isEmpty = !this.dataDeleted && !this.dataAdded;
        return isEmpty ? CommitOutputStatus.EMPTY : CommitOutputStatus.OK;
    }

    private Message visitLog() {
        return ImmutableMessage.builder().text(this.logger.toString()).build();
    }

    private void visitParent(ObjectsActions.RefObjects parent) {
        this.nextTree.putAll(parent.getTree().getValues());
    }

    private void visitAppend(Map<String, String> newBlobs) {
        List hashed = newBlobs.entrySet().stream().map(this::visitAppendEntry).collect(Collectors.toList());
        for (RedundentHashedBlob entry : hashed) {
            this.logger.append(System.lineSeparator()).append("  + ").append(entry.getName());
            if (this.nextTree.containsKey(entry.getName())) {
                Objects.TreeValue previous = this.nextTree.get(entry.getName());
                if (previous.getBlob().equals(entry.getHash())) {
                    this.logger.append(" | no changes");
                    continue;
                }
                this.logger.append(" | changed");
            } else {
                this.logger.append(" | added");
            }
            this.nextBlobs.put(entry.getHash(), ImmutableBlob.builder().id(entry.getHash()).value(entry.getBlob()).build());
            this.nextTree.put(entry.getName(), ImmutableTreeValue.builder().name(entry.getName()).blob(entry.getHash()).build());
            this.dataAdded = true;
        }
        if (!hashed.isEmpty()) {
            this.logger.append(System.lineSeparator());
        }
    }

    private void visitRemove(Collection<String> removeBlobs) {
        if (!removeBlobs.isEmpty()) {
            this.logger.append("Removing following:").append(System.lineSeparator());
        }
        for (String name : removeBlobs) {
            this.logger.append(System.lineSeparator()).append("  - ").append(name);
            if (this.nextTree.containsKey(name)) {
                this.nextTree.remove(name);
                this.dataDeleted = true;
                this.logger.append(" | deleted");
                continue;
            }
            this.logger.append(" | doesn't exist");
        }
        if (!removeBlobs.isEmpty()) {
            this.logger.append(System.lineSeparator());
        }
    }

    private RedundentHashedBlob visitAppendEntry(Map.Entry<String, String> entry) {
        return ImmutableRedundentHashedBlob.builder().hash(Sha2.blobId(entry.getValue())).blob(entry.getValue()).name(entry.getKey()).build();
    }

    @Value.Immutable
    public static interface CommitOutput {
        public CommitOutputStatus getStatus();

        public Repo getRepo();

        public Message getLog();

        public Objects.Ref getRef();

        public Objects.Commit getCommit();

        public Objects.Tree getTree();

        public Collection<Objects.Blob> getBlobs();

        public List<Message> getMessages();
    }

    public static enum CommitOutputStatus {
        OK,
        EMPTY,
        ERROR,
        CONFLICT;

    }

    @Value.Immutable
    public static interface CommitInput {
        public Optional<ObjectsActions.RefObjects> getParent();

        public Repo getRepo();

        public String getRef();

        public String getCommitAuthor();

        public String getCommitMessage();

        public Map<String, String> getAppend();

        public Collection<String> getRemove();
    }

    @Value.Immutable
    public static interface RedundentHashedBlob {
        public String getName();

        public String getHash();

        public String getBlob();
    }

    @Value.Immutable
    static interface RedundentCommitTree {
        public boolean isEmpty();

        public Map<String, Objects.TreeValue> getTreeValues();

        public Map<String, Objects.Blob> getBlobs();

        public String getLog();
    }
}

