/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitVisitor.CommitOutput", generator="Immutables")
@Immutable
public final class ImmutableCommitOutput
implements CommitVisitor.CommitOutput {
    private final CommitVisitor.CommitOutputStatus status;
    private final Repo repo;
    private final Message log;
    private final Objects.Ref ref;
    private final Objects.Commit commit;
    private final Objects.Tree tree;
    private final Collection<Objects.Blob> blobs;
    private final ImmutableList<Message> messages;

    private ImmutableCommitOutput(CommitVisitor.CommitOutputStatus status, Repo repo, Message log, Objects.Ref ref, Objects.Commit commit, Objects.Tree tree, Collection<Objects.Blob> blobs, ImmutableList<Message> messages) {
        this.status = status;
        this.repo = repo;
        this.log = log;
        this.ref = ref;
        this.commit = commit;
        this.tree = tree;
        this.blobs = blobs;
        this.messages = messages;
    }

    @Override
    public CommitVisitor.CommitOutputStatus getStatus() {
        return this.status;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Message getLog() {
        return this.log;
    }

    @Override
    public Objects.Ref getRef() {
        return this.ref;
    }

    @Override
    public Objects.Commit getCommit() {
        return this.commit;
    }

    @Override
    public Objects.Tree getTree() {
        return this.tree;
    }

    @Override
    public Collection<Objects.Blob> getBlobs() {
        return this.blobs;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableCommitOutput withStatus(CommitVisitor.CommitOutputStatus value) {
        if (this.status == value) {
            return this;
        }
        CommitVisitor.CommitOutputStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCommitOutput(newValue, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableCommitOutput(this.status, newValue, this.log, this.ref, this.commit, this.tree, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withLog(Message value) {
        if (this.log == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "log");
        return new ImmutableCommitOutput(this.status, this.repo, newValue, this.ref, this.commit, this.tree, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withRef(Objects.Ref value) {
        if (this.ref == value) {
            return this;
        }
        Objects.Ref newValue = Objects.requireNonNull(value, "ref");
        return new ImmutableCommitOutput(this.status, this.repo, this.log, newValue, this.commit, this.tree, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withCommit(Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        Objects.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, newValue, this.tree, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withTree(Objects.Tree value) {
        if (this.tree == value) {
            return this;
        }
        Objects.Tree newValue = Objects.requireNonNull(value, "tree");
        return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, newValue, this.blobs, this.messages);
    }

    public final ImmutableCommitOutput withBlobs(Collection<Objects.Blob> value) {
        if (this.blobs == value) {
            return this;
        }
        Collection<Objects.Blob> newValue = Objects.requireNonNull(value, "blobs");
        return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, newValue, this.messages);
    }

    public final ImmutableCommitOutput withMessages(Message ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, (ImmutableList<Message>)newValue);
    }

    public final ImmutableCommitOutput withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, (ImmutableList<Message>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitOutput && this.equalTo((ImmutableCommitOutput)another);
    }

    private boolean equalTo(ImmutableCommitOutput another) {
        return this.status.equals((Object)another.status) && this.repo.equals(another.repo) && this.log.equals(another.log) && this.ref.equals(another.ref) && this.commit.equals(another.commit) && this.tree.equals(another.tree) && this.blobs.equals(another.blobs) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.log.hashCode();
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.tree.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitOutput").omitNullValues().add("status", (Object)this.status).add("repo", (Object)this.repo).add("log", (Object)this.log).add("ref", (Object)this.ref).add("commit", (Object)this.commit).add("tree", (Object)this.tree).add("blobs", this.blobs).add("messages", this.messages).toString();
    }

    public static ImmutableCommitOutput copyOf(CommitVisitor.CommitOutput instance) {
        if (instance instanceof ImmutableCommitOutput) {
            return (ImmutableCommitOutput)instance;
        }
        return ImmutableCommitOutput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitVisitor.CommitOutput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_REPO = 2L;
        private static final long INIT_BIT_LOG = 4L;
        private static final long INIT_BIT_REF = 8L;
        private static final long INIT_BIT_COMMIT = 16L;
        private static final long INIT_BIT_TREE = 32L;
        private static final long INIT_BIT_BLOBS = 64L;
        private long initBits = 127L;
        @Nullable
        private CommitVisitor.CommitOutputStatus status;
        @Nullable
        private Repo repo;
        @Nullable
        private Message log;
        @Nullable
        private Objects.Ref ref;
        @Nullable
        private Objects.Commit commit;
        @Nullable
        private Objects.Tree tree;
        @Nullable
        private Collection<Objects.Blob> blobs;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitVisitor.CommitOutput instance) {
            Objects.requireNonNull(instance, "instance");
            this.status(instance.getStatus());
            this.repo(instance.getRepo());
            this.log(instance.getLog());
            this.ref(instance.getRef());
            this.commit(instance.getCommit());
            this.tree(instance.getTree());
            this.blobs(instance.getBlobs());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(CommitVisitor.CommitOutputStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder log(Message log) {
            this.log = Objects.requireNonNull(log, "log");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(Objects.Ref ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Objects.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(Objects.Tree tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobs(Collection<Objects.Blob> blobs) {
            this.blobs = Objects.requireNonNull(blobs, "blobs");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableCommitOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("log");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ref");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("tree");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("blobs");
            }
            return "Cannot build CommitOutput, some of required attributes are not set " + attributes;
        }
    }
}

