/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitVisitor.RedundentCommitTree", generator="Immutables")
@Immutable
final class ImmutableRedundentCommitTree
implements CommitVisitor.RedundentCommitTree {
    private final boolean isEmpty;
    private final ImmutableMap<String, Objects.TreeValue> treeValues;
    private final ImmutableMap<String, Objects.Blob> blobs;
    private final String log;

    private ImmutableRedundentCommitTree(boolean isEmpty, ImmutableMap<String, Objects.TreeValue> treeValues, ImmutableMap<String, Objects.Blob> blobs, String log) {
        this.isEmpty = isEmpty;
        this.treeValues = treeValues;
        this.blobs = blobs;
        this.log = log;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    public ImmutableMap<String, Objects.TreeValue> getTreeValues() {
        return this.treeValues;
    }

    public ImmutableMap<String, Objects.Blob> getBlobs() {
        return this.blobs;
    }

    @Override
    public String getLog() {
        return this.log;
    }

    public final ImmutableRedundentCommitTree withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableRedundentCommitTree(value, this.treeValues, this.blobs, this.log);
    }

    public final ImmutableRedundentCommitTree withTreeValues(Map<String, ? extends Objects.TreeValue> entries) {
        if (this.treeValues == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRedundentCommitTree(this.isEmpty, (ImmutableMap<String, Objects.TreeValue>)newValue, this.blobs, this.log);
    }

    public final ImmutableRedundentCommitTree withBlobs(Map<String, ? extends Objects.Blob> entries) {
        if (this.blobs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRedundentCommitTree(this.isEmpty, this.treeValues, (ImmutableMap<String, Objects.Blob>)newValue, this.log);
    }

    public final ImmutableRedundentCommitTree withLog(String value) {
        String newValue = Objects.requireNonNull(value, "log");
        if (this.log.equals(newValue)) {
            return this;
        }
        return new ImmutableRedundentCommitTree(this.isEmpty, this.treeValues, this.blobs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRedundentCommitTree && this.equalTo((ImmutableRedundentCommitTree)another);
    }

    private boolean equalTo(ImmutableRedundentCommitTree another) {
        return this.isEmpty == another.isEmpty && this.treeValues.equals(another.treeValues) && this.blobs.equals(another.blobs) && this.log.equals(another.log);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isEmpty);
        h += (h << 5) + this.treeValues.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        h += (h << 5) + this.log.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RedundentCommitTree").omitNullValues().add("isEmpty", this.isEmpty).add("treeValues", this.treeValues).add("blobs", this.blobs).add("log", (Object)this.log).toString();
    }

    public static ImmutableRedundentCommitTree copyOf(CommitVisitor.RedundentCommitTree instance) {
        if (instance instanceof ImmutableRedundentCommitTree) {
            return (ImmutableRedundentCommitTree)instance;
        }
        return ImmutableRedundentCommitTree.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitVisitor.RedundentCommitTree", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private static final long INIT_BIT_LOG = 2L;
        private long initBits = 3L;
        private boolean isEmpty;
        private ImmutableMap.Builder<String, Objects.TreeValue> treeValues = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Objects.Blob> blobs = ImmutableMap.builder();
        @Nullable
        private String log;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitVisitor.RedundentCommitTree instance) {
            Objects.requireNonNull(instance, "instance");
            this.isEmpty(instance.isEmpty());
            this.putAllTreeValues(instance.getTreeValues());
            this.putAllBlobs(instance.getBlobs());
            this.log(instance.getLog());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTreeValues(String key, Objects.TreeValue value) {
            this.treeValues.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTreeValues(Map.Entry<String, ? extends Objects.TreeValue> entry) {
            this.treeValues.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeValues(Map<String, ? extends Objects.TreeValue> entries) {
            this.treeValues = ImmutableMap.builder();
            return this.putAllTreeValues(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTreeValues(Map<String, ? extends Objects.TreeValue> entries) {
            this.treeValues.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(String key, Objects.Blob value) {
            this.blobs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(Map.Entry<String, ? extends Objects.Blob> entry) {
            this.blobs.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobs(Map<String, ? extends Objects.Blob> entries) {
            this.blobs = ImmutableMap.builder();
            return this.putAllBlobs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBlobs(Map<String, ? extends Objects.Blob> entries) {
            this.blobs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder log(String log) {
            this.log = Objects.requireNonNull(log, "log");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRedundentCommitTree build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRedundentCommitTree(this.isEmpty, (ImmutableMap<String, Objects.TreeValue>)this.treeValues.build(), (ImmutableMap<String, Objects.Blob>)this.blobs.build(), this.log);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("log");
            }
            return "Cannot build RedundentCommitTree, some of required attributes are not set " + attributes;
        }
    }
}

