/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitVisitor.RedundentHashedBlob", generator="Immutables")
@Immutable
public final class ImmutableRedundentHashedBlob
implements CommitVisitor.RedundentHashedBlob {
    private final String name;
    private final String hash;
    private final String blob;

    private ImmutableRedundentHashedBlob(String name, String hash, String blob) {
        this.name = name;
        this.hash = hash;
        this.blob = blob;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getBlob() {
        return this.blob;
    }

    public final ImmutableRedundentHashedBlob withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRedundentHashedBlob(newValue, this.hash, this.blob);
    }

    public final ImmutableRedundentHashedBlob withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableRedundentHashedBlob(this.name, newValue, this.blob);
    }

    public final ImmutableRedundentHashedBlob withBlob(String value) {
        String newValue = Objects.requireNonNull(value, "blob");
        if (this.blob.equals(newValue)) {
            return this;
        }
        return new ImmutableRedundentHashedBlob(this.name, this.hash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRedundentHashedBlob && this.equalTo((ImmutableRedundentHashedBlob)another);
    }

    private boolean equalTo(ImmutableRedundentHashedBlob another) {
        return this.name.equals(another.name) && this.hash.equals(another.hash) && this.blob.equals(another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.blob.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RedundentHashedBlob").omitNullValues().add("name", (Object)this.name).add("hash", (Object)this.hash).add("blob", (Object)this.blob).toString();
    }

    public static ImmutableRedundentHashedBlob copyOf(CommitVisitor.RedundentHashedBlob instance) {
        if (instance instanceof ImmutableRedundentHashedBlob) {
            return (ImmutableRedundentHashedBlob)instance;
        }
        return ImmutableRedundentHashedBlob.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitVisitor.RedundentHashedBlob", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_BLOB = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private String hash;
        @Nullable
        private String blob;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitVisitor.RedundentHashedBlob instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.hash(instance.getHash());
            this.blob(instance.getBlob());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blob(String blob) {
            this.blob = Objects.requireNonNull(blob, "blob");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRedundentHashedBlob build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRedundentHashedBlob(this.name, this.hash, this.blob);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("blob");
            }
            return "Cannot build RedundentHashedBlob, some of required attributes are not set " + attributes;
        }
    }
}

