/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.diff;

import io.resys.thena.docdb.api.models.Objects;
import java.time.LocalDateTime;
import java.util.Optional;

public interface CommitHistory {
    public int getIndex();

    public Objects.Commit getCommit();

    public Optional<CommitHistory> getBefore();

    public Optional<CommitHistory> getAfter();

    public CommitHistory getSelect();

    public CommitHistory setSelect();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public CommitHistory from(Objects repo, String commit) {
            return new CommitHistoryBean(repo, commit);
        }

        public CommitHistory from(Objects repo, String commit, LocalDateTime at) {
            CommitHistoryBean history;
            CommitHistory start = history = new CommitHistoryBean(repo, commit);
            while (start.getCommit().getDateTime().isAfter(at)) {
                start = start.getBefore().get();
            }
            return start;
        }
    }

    public static class CommitHistoryBean
    implements CommitHistory {
        private final Objects repo;
        private final int index;
        private final Objects.Commit commit;
        private final Optional<CommitHistory> after;
        private final CommitHistorySelectBean select;
        private Optional<CommitHistory> before;

        public CommitHistoryBean(Objects repo, String commit) {
            this.index = 0;
            this.repo = repo;
            this.commit = (Objects.Commit)repo.getValues().get(commit);
            this.after = Optional.empty();
            this.select = new CommitHistorySelectBean().setSelect(this);
        }

        private CommitHistoryBean(Objects repo, Objects.Commit commit, int index, CommitHistory after, CommitHistorySelectBean select) {
            this.index = index;
            this.repo = repo;
            this.commit = commit;
            this.after = Optional.of(after);
            this.select = select;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Objects.Commit getCommit() {
            return this.commit;
        }

        @Override
        public Optional<CommitHistory> getBefore() {
            if (this.before != null) {
                return this.before;
            }
            if (this.commit.getParent().isEmpty()) {
                this.before = Optional.empty();
                return this.before;
            }
            Objects.Commit before = (Objects.Commit)this.repo.getValues().get(this.commit.getParent().get());
            this.before = Optional.of(new CommitHistoryBean(this.repo, before, this.index + 1, this, this.select));
            return this.before;
        }

        @Override
        public Optional<CommitHistory> getAfter() {
            return this.after;
        }

        @Override
        public CommitHistory setSelect() {
            this.select.setSelect(this);
            return this;
        }

        @Override
        public CommitHistory getSelect() {
            this.select.getSelect();
            return this;
        }
    }

    public static class CommitHistorySelectBean {
        private CommitHistoryBean select;

        public CommitHistoryBean getSelect() {
            return this.select;
        }

        public CommitHistorySelectBean setSelect(CommitHistoryBean select) {
            this.select = select;
            return this;
        }
    }
}

