/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.objects;

import io.resys.thena.docdb.api.actions.ImmutableBlobObject;
import io.resys.thena.docdb.api.actions.ImmutableBlobObjects;
import io.resys.thena.docdb.api.actions.ImmutableObjectsResult;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.exceptions.RepoException;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.objects.ImmutableBlobAndTree;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class BlobStateBuilderDefault
implements ObjectsActions.BlobStateBuilder {
    private final ClientState state;
    private String repoName;
    private String refOrCommitOrTag;
    private List<String> blobName = new ArrayList<String>();

    public BlobStateBuilderDefault(ClientState state) {
        this.state = state;
    }

    @Override
    public BlobStateBuilderDefault repo(String repoName) {
        this.repoName = repoName;
        return this;
    }

    @Override
    public BlobStateBuilderDefault anyId(String refOrCommitOrTag) {
        this.refOrCommitOrTag = refOrCommitOrTag;
        return this;
    }

    @Override
    public BlobStateBuilderDefault blobName(String blobName) {
        this.blobName.add(blobName);
        return this;
    }

    @Override
    public BlobStateBuilderDefault blobNames(List<String> blobName) {
        this.blobName.addAll(blobName);
        return this;
    }

    @Override
    public Uni<ObjectsActions.ObjectsResult<ObjectsActions.BlobObjects>> list() {
        RepoAssert.notEmpty(this.repoName, () -> "repoName is not defined!");
        RepoAssert.notEmpty(this.refOrCommitOrTag, () -> "refOrCommitOrTag is not defined!");
        RepoAssert.isTrue(!this.blobName.isEmpty(), () -> "blobName is not defined!");
        return this.state.repos().getByNameOrId(this.repoName).onItem().transformToUni(existing -> {
            if (existing == null) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(RepoException.builder().notRepoWithName(this.repoName)).build());
            }
            ClientState.ClientRepoState ctx = this.state.withRepo((Repo)existing);
            return this.getTagCommit(this.refOrCommitOrTag, ctx).onItem().transformToUni(tag -> {
                if (tag == null) {
                    return this.getRefCommit(this.refOrCommitOrTag, ctx);
                }
                return Uni.createFrom().item(tag);
            }).onItem().transformToUni(commitId -> {
                if (commitId == null) {
                    return this.getCommit(this.refOrCommitOrTag, ctx);
                }
                return this.getCommit((String)commitId, ctx);
            }).onItem().transformToUni(commit -> {
                if (commit == null) {
                    return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(this.noCommit((Repo)existing)).build());
                }
                return this.getListState((Repo)existing, (Objects.Commit)commit, ctx);
            });
        });
    }

    @Override
    public Uni<ObjectsActions.ObjectsResult<ObjectsActions.BlobObject>> get() {
        RepoAssert.notEmpty(this.repoName, () -> "repoName is not defined!");
        RepoAssert.notEmpty(this.refOrCommitOrTag, () -> "refOrCommitOrTag is not defined!");
        RepoAssert.isTrue(!this.blobName.isEmpty(), () -> "blobName is not defined!");
        return this.state.repos().getByNameOrId(this.repoName).onItem().transformToUni(existing -> {
            if (existing == null) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(RepoException.builder().notRepoWithName(this.repoName)).build());
            }
            ClientState.ClientRepoState ctx = this.state.withRepo((Repo)existing);
            return this.getTagCommit(this.refOrCommitOrTag, ctx).onItem().transformToUni(tag -> {
                if (tag == null) {
                    return this.getRefCommit(this.refOrCommitOrTag, ctx);
                }
                return Uni.createFrom().item(tag);
            }).onItem().transformToUni(commitId -> {
                if (commitId == null) {
                    return this.getCommit(this.refOrCommitOrTag, ctx);
                }
                return this.getCommit((String)commitId, ctx);
            }).onItem().transformToUni(commit -> {
                if (commit == null) {
                    return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(this.noCommit((Repo)existing)).build());
                }
                return this.getState((Repo)existing, (Objects.Commit)commit, ctx);
            });
        });
    }

    private Message noCommit(Repo repo) {
        return ImmutableMessage.builder().text("Repo with name: '" + repo.getName() + "'" + " does not contain: tag, ref or commit with id:" + " '" + this.refOrCommitOrTag + "'").build();
    }

    private Message noBlob(Repo repo, Objects.Tree tree) {
        return ImmutableMessage.builder().text("Repo with name: '" + repo.getName() + "'" + ", tag, ref or commit with id: " + " '" + this.refOrCommitOrTag + "'" + " and tree: " + tree.toString() + " does not contain a blob with name: " + "'" + this.blobName + "'" + "!").build();
    }

    private Uni<ObjectsActions.ObjectsResult<ObjectsActions.BlobObject>> getState(Repo repo, Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return this.getTree(commit, ctx).onItem().transformToUni(tree -> this.getBlob((Objects.Tree)tree, ctx)).onItem().transformToUni(blobTree -> {
            if (blobTree.getBlob().size() != 1) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(this.noBlob(repo, blobTree.getTree())).build());
            }
            return Uni.createFrom().item(ImmutableObjectsResult.builder().repo(repo).objects(ImmutableBlobObject.builder().repo(repo).tree(blobTree.getTree()).commit(commit).blob(blobTree.getBlob().isEmpty() ? null : blobTree.getBlob().get(0)).build()).status(ObjectsActions.ObjectsStatus.OK).build());
        });
    }

    private Uni<ObjectsActions.ObjectsResult<ObjectsActions.BlobObjects>> getListState(Repo repo, Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return this.getTree(commit, ctx).onItem().transformToUni(tree -> this.getBlob((Objects.Tree)tree, ctx)).onItem().transformToUni(blobAndTree -> {
            if (blobAndTree.getBlob().isEmpty()) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(this.noBlob(repo, blobAndTree.getTree())).build());
            }
            return Uni.createFrom().item(ImmutableObjectsResult.builder().repo(repo).objects(ImmutableBlobObjects.builder().repo(repo).tree(blobAndTree.getTree()).commit(commit).blob(blobAndTree.getBlob()).build()).status(ObjectsActions.ObjectsStatus.OK).build());
        });
    }

    private Uni<String> getTagCommit(String tagName, ClientState.ClientRepoState ctx) {
        return ctx.query().tags().name(tagName).get().onItem().transform(tag -> tag == null ? null : tag.getCommit());
    }

    private Uni<String> getRefCommit(String refName, ClientState.ClientRepoState ctx) {
        return ctx.query().refs().name(refName).onItem().transform(ref -> ref == null ? null : ref.getCommit());
    }

    private Uni<Objects.Tree> getTree(Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return ctx.query().trees().id(commit.getTree());
    }

    private Uni<Objects.Commit> getCommit(String commit, ClientState.ClientRepoState ctx) {
        return ctx.query().commits().id(commit);
    }

    private Uni<BlobAndTree> getBlob(Objects.Tree tree, ClientState.ClientRepoState ctx) {
        List<String> entry = tree.getValues().entrySet().stream().filter(e -> this.blobName.contains(((Objects.TreeValue)e.getValue()).getName())).map(e -> ((Objects.TreeValue)e.getValue()).getBlob()).collect(Collectors.toList());
        if (!entry.isEmpty()) {
            return ctx.query().blobs().id(entry).onItem().transform(blobs -> ImmutableBlobAndTree.builder().blob((Iterable<? extends Objects.Blob>)blobs).tree(tree).build());
        }
        return Uni.createFrom().item((Object)ImmutableBlobAndTree.builder().tree(tree).build());
    }

    @Value.Immutable
    public static interface BlobAndTree {
        public List<Objects.Blob> getBlob();

        public Objects.Tree getTree();
    }
}

