/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.objects;

import io.resys.thena.docdb.api.actions.ImmutableCommitObjects;
import io.resys.thena.docdb.api.actions.ImmutableObjectsResult;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.exceptions.RepoException;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.stream.Collectors;

public class CommitStateBuilderDefault
implements ObjectsActions.CommitStateBuilder {
    private final ClientState state;
    private String repoName;
    private String refOrCommitOrTag;
    private boolean blobs;

    public CommitStateBuilderDefault(ClientState state) {
        this.state = state;
    }

    @Override
    public ObjectsActions.CommitStateBuilder repo(String repoName) {
        this.repoName = repoName;
        return this;
    }

    @Override
    public ObjectsActions.CommitStateBuilder anyId(String refOrCommitOrTag) {
        this.refOrCommitOrTag = refOrCommitOrTag;
        return this;
    }

    @Override
    public ObjectsActions.CommitStateBuilder blobs(boolean load) {
        this.blobs = load;
        return this;
    }

    @Override
    public ObjectsActions.CommitStateBuilder blobs() {
        this.blobs = true;
        return this;
    }

    @Override
    public Uni<ObjectsActions.ObjectsResult<ObjectsActions.CommitObjects>> build() {
        RepoAssert.notEmpty(this.repoName, () -> "repoName is not defined!");
        RepoAssert.notEmpty(this.refOrCommitOrTag, () -> "refOrCommitOrTag is not defined!");
        return this.state.repos().getByNameOrId(this.repoName).onItem().transformToUni(existing -> {
            if (existing == null) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(RepoException.builder().notRepoWithName(this.repoName)).build());
            }
            ClientState.ClientRepoState ctx = this.state.withRepo((Repo)existing);
            return this.getTagCommit(this.refOrCommitOrTag, ctx).onItem().transformToUni(tag -> {
                if (tag == null) {
                    return this.getRefCommit(this.refOrCommitOrTag, ctx);
                }
                return Uni.createFrom().item(tag);
            }).onItem().transformToUni(commitId -> {
                if (commitId == null) {
                    return this.getCommit(this.refOrCommitOrTag, ctx);
                }
                return this.getCommit((String)commitId, ctx);
            }).onItem().transformToUni(commit -> {
                if (commit == null) {
                    return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(this.noCommit((Repo)existing)).build());
                }
                return this.getState((Repo)existing, (Objects.Commit)commit, ctx);
            });
        });
    }

    private Message noCommit(Repo repo) {
        return ImmutableMessage.builder().text("Repo with name: '" + repo.getName() + "'" + " does not contain: tag, ref or commit with id:" + " '" + this.refOrCommitOrTag + "'").build();
    }

    private Uni<ObjectsActions.ObjectsResult<ObjectsActions.CommitObjects>> getState(Repo repo, Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return this.getTree(commit, ctx).onItem().transformToUni(tree -> {
            if (this.blobs) {
                return this.getBlobs((Objects.Tree)tree, ctx).onItem().transform(blobs -> ImmutableObjectsResult.builder().repo(repo).objects(ImmutableCommitObjects.builder().repo(repo).tree((Objects.Tree)tree).blobs((Map<String, ? extends Objects.Blob>)blobs).commit(commit).build()).repo(repo).status(ObjectsActions.ObjectsStatus.OK).build());
            }
            return Uni.createFrom().item(ImmutableObjectsResult.builder().repo(repo).objects(ImmutableCommitObjects.builder().repo(repo).tree((Objects.Tree)tree).commit(commit).build()).status(ObjectsActions.ObjectsStatus.OK).build());
        });
    }

    private Uni<String> getTagCommit(String tagName, ClientState.ClientRepoState ctx) {
        return ctx.query().tags().name(tagName).get().onItem().transform(tag -> tag == null ? null : tag.getCommit());
    }

    private Uni<String> getRefCommit(String refName, ClientState.ClientRepoState ctx) {
        return ctx.query().refs().name(refName).onItem().transform(ref -> ref == null ? null : ref.getCommit());
    }

    private Uni<Objects.Tree> getTree(Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return ctx.query().trees().id(commit.getTree());
    }

    private Uni<Objects.Commit> getCommit(String commit, ClientState.ClientRepoState ctx) {
        return ctx.query().commits().id(commit);
    }

    private Uni<Map<String, Objects.Blob>> getBlobs(Objects.Tree tree, ClientState.ClientRepoState ctx) {
        return ctx.query().blobs().find(tree).collectItems().asList().onItem().transform(blobs -> blobs.stream().collect(Collectors.toMap(r -> r.getId(), r -> r)));
    }
}

