/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.objects;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.objects.BlobStateBuilderDefault;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BlobStateBuilderDefault.BlobAndTree", generator="Immutables")
@Immutable
public final class ImmutableBlobAndTree
implements BlobStateBuilderDefault.BlobAndTree {
    private final ImmutableList<Objects.Blob> blob;
    private final Objects.Tree tree;

    private ImmutableBlobAndTree(ImmutableList<Objects.Blob> blob, Objects.Tree tree) {
        this.blob = blob;
        this.tree = tree;
    }

    public ImmutableList<Objects.Blob> getBlob() {
        return this.blob;
    }

    @Override
    public Objects.Tree getTree() {
        return this.tree;
    }

    public final ImmutableBlobAndTree withBlob(Objects.Blob ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBlobAndTree((ImmutableList<Objects.Blob>)newValue, this.tree);
    }

    public final ImmutableBlobAndTree withBlob(Iterable<? extends Objects.Blob> elements) {
        if (this.blob == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBlobAndTree((ImmutableList<Objects.Blob>)newValue, this.tree);
    }

    public final ImmutableBlobAndTree withTree(Objects.Tree value) {
        if (this.tree == value) {
            return this;
        }
        Objects.Tree newValue = Objects.requireNonNull(value, "tree");
        return new ImmutableBlobAndTree(this.blob, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlobAndTree && this.equalTo((ImmutableBlobAndTree)another);
    }

    private boolean equalTo(ImmutableBlobAndTree another) {
        return this.blob.equals(another.blob) && this.tree.equals(another.tree);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.blob.hashCode();
        h += (h << 5) + this.tree.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BlobAndTree").omitNullValues().add("blob", this.blob).add("tree", (Object)this.tree).toString();
    }

    public static ImmutableBlobAndTree copyOf(BlobStateBuilderDefault.BlobAndTree instance) {
        if (instance instanceof ImmutableBlobAndTree) {
            return (ImmutableBlobAndTree)instance;
        }
        return ImmutableBlobAndTree.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlobStateBuilderDefault.BlobAndTree", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TREE = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Objects.Blob> blob = ImmutableList.builder();
        @Nullable
        private Objects.Tree tree;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BlobStateBuilderDefault.BlobAndTree instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllBlob(instance.getBlob());
            this.tree(instance.getTree());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBlob(Objects.Blob element) {
            this.blob.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBlob(Objects.Blob ... elements) {
            this.blob.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blob(Iterable<? extends Objects.Blob> elements) {
            this.blob = ImmutableList.builder();
            return this.addAllBlob(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBlob(Iterable<? extends Objects.Blob> elements) {
            this.blob.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(Objects.Tree tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBlobAndTree build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlobAndTree((ImmutableList<Objects.Blob>)this.blob.build(), this.tree);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build BlobAndTree, some of required attributes are not set " + attributes;
        }
    }
}

