/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.objects;

import io.resys.thena.docdb.api.actions.ImmutableObjectsResult;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.exceptions.RepoException;
import io.resys.thena.docdb.api.models.ImmutableObjects;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.stream.Collectors;

public class RepoStateBuilderDefault
implements ObjectsActions.RepoStateBuilder {
    private final ClientState state;
    private String repoName;

    public RepoStateBuilderDefault(ClientState state) {
        this.state = state;
    }

    @Override
    public ObjectsActions.RepoStateBuilder repo(String repoName) {
        this.repoName = repoName;
        return this;
    }

    @Override
    public Uni<ObjectsActions.ObjectsResult<Objects>> build() {
        RepoAssert.notEmpty(this.repoName, () -> "repoName not defined!");
        return this.state.repos().getByNameOrId(this.repoName).onItem().transformToUni(existing -> {
            if (existing == null) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(RepoException.builder().notRepoWithName(this.repoName)).build());
            }
            return this.getState((Repo)existing, this.state.withRepo((Repo)existing));
        });
    }

    private Uni<ObjectsActions.ObjectsResult<Objects>> getState(Repo repo, ClientState.ClientRepoState ctx) {
        Uni objects = Uni.combine().all().unis(this.getRefs(repo, ctx), this.getTags(repo, ctx), this.getBlobs(repo, ctx), this.getTrees(repo, ctx), this.getCommits(repo, ctx)).combinedWith(raw -> {
            ImmutableObjects.Builder builder = ImmutableObjects.builder();
            raw.stream().map(r -> (Objects)r).forEach(r -> builder.putAllRefs(r.getRefs()).putAllTags(r.getTags()).putAllValues(r.getValues()));
            return builder.build();
        });
        return objects.onItem().transform(state -> ImmutableObjectsResult.builder().objects((Objects)state).status(ObjectsActions.ObjectsStatus.OK).build());
    }

    private Uni<Objects> getRefs(Repo repo, ClientState.ClientRepoState ctx) {
        return ctx.query().refs().find().collectItems().asList().onItem().transform(refs -> ImmutableObjects.builder().putAllRefs(refs.stream().collect(Collectors.toMap(r -> r.getName(), r -> r))).build());
    }

    private Uni<Objects> getTags(Repo repo, ClientState.ClientRepoState ctx) {
        return ctx.query().tags().find().collectItems().asList().onItem().transform(refs -> ImmutableObjects.builder().putAllTags(refs.stream().collect(Collectors.toMap(r -> r.getName(), r -> r))).build());
    }

    private Uni<Objects> getBlobs(Repo repo, ClientState.ClientRepoState ctx) {
        return ctx.query().blobs().find().collectItems().asList().onItem().transform(blobs -> ImmutableObjects.builder().putAllValues(blobs.stream().collect(Collectors.toMap(r -> r.getId(), r -> r))).build());
    }

    private Uni<Objects> getTrees(Repo repo, ClientState.ClientRepoState ctx) {
        return ctx.query().trees().find().collectItems().asList().onItem().transform(trees -> ImmutableObjects.builder().putAllValues(trees.stream().collect(Collectors.toMap(r -> r.getId(), r -> r))).build());
    }

    private Uni<Objects> getCommits(Repo repo, ClientState.ClientRepoState ctx) {
        return ctx.query().commits().find().collectItems().asList().onItem().transform(commits -> ImmutableObjects.builder().putAllValues(commits.stream().collect(Collectors.toMap(r -> r.getId(), r -> r))).build());
    }
}

